/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chat;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.MessagePiece;
import org.kingdoms.locale.compiler.builders.context.ComplexMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.MessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.XComponentBuilder;

public class TagMessagePiece
extends MessagePiece {
    private final String name;

    public TagMessagePiece(String name) {
        this.name = name;
    }

    KingdomsLang getTagFormat(MessageBuilderContextProvider context) {
        OfflinePlayer player = PlayerUtils.getOfflinePlayer(this.name);
        if (player == null) {
            return KingdomsLang.TAGS_UNKNOWN_PLAYER;
        }
        if (player.isOnline()) {
            Object receiver = context.getSettings().relationalSecond;
            if (receiver instanceof OfflinePlayer && player.getUniqueId().equals(((OfflinePlayer)receiver).getUniqueId())) {
                return KingdomsLang.TAGS_TAGGED;
            }
            return KingdomsLang.TAGS_OTHERS;
        }
        return KingdomsLang.TAGS_OFFLINE;
    }

    @Override
    public void build(ComplexMessageBuilderContextProvider context) {
        KingdomsLang lang = this.getTagFormat(context);
        MessageObject format = lang.getMessageObject(LanguageManager.getDefaultLanguage());
        XComponentBuilder varBuilder = format.build(context.getComponent(), context.getSettings().parse("tag", this.name));
        context.newComponent(ComponentBuilder.FormatRetention.ALL);
        BaseComponent[][] baseComponentArray = varBuilder.create();
        int n = baseComponentArray.length;
        for (int i = 0; i < n; ++i) {
            BaseComponent[] comp;
            for (BaseComponent baseComponent : comp = baseComponentArray[i]) {
                context.getBuilder().append(baseComponent, ComponentBuilder.FormatRetention.NONE);
            }
        }
        lang.getProvider(LanguageManager.getDefaultLanguage()).handleExtraServices((CommandSender)context.getSettings().main, context.getSettings());
    }

    @Override
    public void build(PlainMessageBuilderContextProvider context) {
        MessageObject format = this.getTagFormat(context).getMessageObject(LanguageManager.getDefaultLanguage());
        String tag = format.buildPlain(context.getSettings().parse("tag", this.name));
        context.getBuilder().append(tag);
    }

    @Override
    public int jsonLength() {
        return this.length();
    }

    @Override
    public int length() {
        return this.name.length() + 2;
    }
}

