/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.daily;

import java.time.Duration;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.data.managers.NationManager;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.general.GroupServerTaxPayEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.abstraction.ProlongedTask;
import org.kingdoms.managers.daily.InactivityManager;
import org.kingdoms.managers.daily.TaxManager;
import org.kingdoms.managers.daily.TimeZoneHandler;
import org.kingdoms.managers.daily.TopRewardsManager;
import org.kingdoms.managers.logger.KingdomsLogger;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.string.StringUtils;

public final class DailyChecksManager
extends ProlongedTask {
    private static final DailyChecksManager INSTANCE = new DailyChecksManager();

    public static DailyChecksManager getInstance() {
        return INSTANCE;
    }

    private DailyChecksManager() {
        super(Duration.ofDays(KingdomsConfig.DAILY_CHECKS_INTERVAL.getInt()), TimeZoneHandler.DAILY_CHECKS, "daily checks", new String[]{"prolonged-tasks", "daily-checks"}, KingdomsConfig.DAILY_CHECKS_COUNTDOWNS.getStringList());
    }

    @Override
    public void remind(String formattedTime) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            KingdomsLang.TAX_REMINDER.sendMessage((CommandSender)player, "time", formattedTime);
        }
        KingdomsLang.TAX_REMINDER.sendMessage((CommandSender)Bukkit.getConsoleSender(), "time", formattedTime);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void run() {
        Kingdoms plugin = Kingdoms.get();
        MessageHandler.sendConsolePluginMessage("&2Performing daily checks...");
        KingdomsLogger.getMain().log("Performing daily checks...");
        boolean kingdomTaxes = KingdomsConfig.TAX_KINGDOMS_ENABLED.getBoolean();
        Set<Nation> nations = Collections.newSetFromMap(new IdentityHashMap(NationManager.getNames().size()));
        String taxEquation = KingdomsConfig.TAX_KINGDOMS_SCALING.getString();
        long kingdomsTaxAge = KingdomsConfig.TAX_KINGDOMS_AGE.getTimeMillis();
        Long playerInactivity = KingdomsConfig.INACTIVITY_MEMBER_KICK.getTimeMillis();
        Long kingdomInactivity = KingdomsConfig.INACTIVITY_KINGDOM_DISBAND.getTimeMillis();
        boolean checkPlayerInactivity = playerInactivity != null && playerInactivity > 0L;
        boolean memberTaxEnabled = KingdomsConfig.TAX_KINGDOMS_MEMBERS_ENABLED.getBoolean();
        Long membersTaxAge = KingdomsConfig.TAX_KINGDOMS_MEMBERS_AGE.getTimeMillis();
        if (membersTaxAge == null) {
            memberTaxEnabled = false;
        }
        boolean nationMemberTaxEnabled = KingdomsConfig.TAX_NATIONS_MEMBERS_ENABLED.getBoolean();
        boolean useRpKingdom = KingdomsConfig.TAX_KINGDOMS_USE_RESOURCE_POINTS.getBoolean();
        long now = System.currentTimeMillis();
        TopRewardsManager.rewardTopKingdoms();
        TopRewardsManager.rewardTopNations();
        for (Kingdom kingdom : plugin.getDataCenter().getKingdomManager().getKingdoms()) {
            boolean needsToPayTaxes;
            boolean bl = needsToPayTaxes = !kingdom.isPermanent() && kingdomTaxes;
            if (needsToPayTaxes && now - kingdom.getSince() < kingdomsTaxAge) {
                for (Player member : kingdom.getOnlineMembers()) {
                    KingdomsLang.TAX_KINGDOM_AGE.sendMessage((CommandSender)member);
                }
                needsToPayTaxes = false;
            }
            double total = 0.0;
            boolean isInactive = !kingdom.isPermanent() && kingdomInactivity != null && kingdomInactivity > 0L;
            for (Object member : kingdom.getPlayerMembers()) {
                Player player;
                long lastPlayed = member.getLastPlayed();
                long passedSinceLastPlay = now - lastPlayed;
                if (isInactive && passedSinceLastPlay < kingdomInactivity) {
                    isInactive = false;
                }
                if (checkPlayerInactivity && passedSinceLastPlay > playerInactivity) {
                    InactivityManager.handleInactiveMember(kingdom, (OfflinePlayer)member);
                    continue;
                }
                if (!memberTaxEnabled) continue;
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)member);
                if (!kp.hasKingdom()) {
                    MessageHandler.sendConsolePluginMessage("&4Unknown kingdom for player &e" + member.getName() + " &4while collecting member taxes for &e" + kingdom.getName() + " &4kingdom. Removing them...");
                    KingdomsLogger.getMain().log("Unknown kingdom for player &e" + member.getName() + " while collecting member taxes for " + kingdom.getName() + " kingdom. Removing them...");
                    kingdom.getMembers().remove(member.getUniqueId());
                    continue;
                }
                if (now - kp.getJoinedAt() > membersTaxAge) {
                    if (!kp.hasPermission(StandardKingdomPermission.EXCLUDE_TAX)) {
                        Pair<Boolean, Double> success = kingdom.payTaxes((OfflinePlayer)member);
                        double paid = success.getValue();
                        String fancyTaxNumber = StringUtils.toFancyNumber(paid);
                        String balance = StringUtils.toFancyNumber(ServiceVault.getMoney(kp.getOfflinePlayer()));
                        if (success.getKey().booleanValue()) {
                            if (member.isOnline() && paid != 0.0) {
                                KingdomsLang.TAX_PAID.sendMessage((CommandSender)member.getPlayer(), "tax", fancyTaxNumber, "bal", balance);
                            }
                            total += paid;
                            continue;
                        }
                        if (!KingdomsConfig.TAX_KINGDOMS_MEMBERS_KICK_IF_CANT_PAY.getBoolean()) continue;
                        for (Player player2 : kingdom.getOnlineMembers()) {
                            if (player2.getUniqueId().equals(member.getUniqueId())) {
                                KingdomsLang.TAX_KICK.sendMessage((CommandSender)player2, (OfflinePlayer)member, new Object[]{"tax", fancyTaxNumber, "bal", balance});
                                continue;
                            }
                            KingdomsLang.TAX_KICK_ANNOUNCE.sendMessage((CommandSender)player2, (OfflinePlayer)member, new Object[]{"tax", fancyTaxNumber, "bal", balance});
                        }
                        Bukkit.getScheduler().runTask((Plugin)plugin, () -> kp.leaveKingdom(LeaveReason.TAX));
                        KingdomsLogger.getMain().log("Kicked " + member.getName() + " from " + kingdom.getName() + " kingdom due to not being able to pay taxes: " + balance + " < " + fancyTaxNumber);
                        continue;
                    }
                    player = kp.getPlayer();
                    if (player == null) continue;
                    KingdomsLang.TAX_EXCLUDED_PERMISSION.sendMessage((CommandSender)player);
                    continue;
                }
                player = kp.getPlayer();
                if (player == null) continue;
                KingdomsLang.TAX_EXCLUDED_NEW.sendMessage((CommandSender)player);
                KingdomsLogger.getMain().log(member.getName() + " from " + kingdom.getName() + " was excluded from paying taxes because they're a new member.");
            }
            if (kingdomTaxes) {
                Object member;
                String fancyTaxNumber = StringUtils.toFancyNumber(total);
                member = kingdom.getOnlineMembers().iterator();
                while (member.hasNext()) {
                    Player player = (Player)member.next();
                    KingdomsLang.TAX_TOTAL.sendMessage((CommandSender)player, "tax", fancyTaxNumber);
                }
            }
            if (isInactive && InactivityManager.disband(kingdom)) continue;
            Nation nation = kingdom.getNation();
            if (nation != null) {
                nations.add(nation);
            }
            if (!needsToPayTaxes) continue;
            if (nation == null) {
                double pacifismFactor = kingdom.isPacifist() ? MathUtils.eval(KingdomsConfig.TAX_KINGDOMS_PACIFISM_FACTOR.getString(), kingdom, new Object[0]) : 0.0;
                double tax = MathUtils.eval(taxEquation, kingdom, "pacifism_factor", pacifismFactor, "pacifism_factor", pacifismFactor);
                String fancyTaxNumber = StringUtils.toFancyNumber(tax);
                GroupServerTaxPayEvent event = new GroupServerTaxPayEvent(kingdom, tax);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                tax = event.getAmount();
                if (kingdom.hasMoney(tax)) {
                    if (tax == 0.0) continue;
                    if (useRpKingdom) {
                        kingdom.addResourcePoints((long)(-tax));
                    } else {
                        kingdom.addBank(-tax);
                    }
                    for (Player player : kingdom.getOnlineMembers()) {
                        KingdomsLang.TAX_KINGDOM_PAID.sendMessage((CommandSender)player, "tax", fancyTaxNumber);
                    }
                    continue;
                }
                if (KingdomsConfig.TAX_KINGDOMS_DISBAND_IF_CANT_PAY.getBoolean()) {
                    KingdomsLogger.getMain().log(kingdom.getName() + " was disbanded due to not being able to pay taxes: " + StringUtils.toFancyNumber(useRpKingdom ? (double)kingdom.getResourcePoints() : kingdom.getBank()) + " < " + fancyTaxNumber);
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (kingdom.isMember((OfflinePlayer)player)) {
                            KingdomsLang.TAX_KINGDOM_DISBANDED.sendError((CommandSender)player, "tax", fancyTaxNumber);
                            continue;
                        }
                        KingdomsLang.TAX_KINGDOM_DISBANDED_ANNOUNCE.sendMessage((CommandSender)player, "kingdom", kingdom.getName(), "tax", fancyTaxNumber);
                    }
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                        if (!kingdom.triggerDisbandEvent(GroupDisband.Reason.TAXES).isCancelled()) {
                            KingdomsLang.TAX_KINGDOM_DISBANDED_ANNOUNCE.sendMessage((CommandSender)Bukkit.getConsoleSender(), new MessageBuilder().withContext(kingdom).raws("kingdom", kingdom.getName(), "tax", fancyTaxNumber));
                            kingdom.disband(null);
                        }
                    });
                    continue;
                }
                if (useRpKingdom) {
                    kingdom.setResourcePoints(0L);
                    continue;
                }
                kingdom.setBank(0.0);
                continue;
            }
            if (!nationMemberTaxEnabled) continue;
            TaxManager.kingdomPayNationTax(nation, kingdom);
        }
        TaxManager.handleNationTaxes(nations);
    }

    static {
        KingdomsLogger.getMain().newLine().newLine().log("Starting daily checks services...").log("Timezone: " + TimeZoneHandler.SERVER_TIME_ZONE).log("Cycle time: " + TimeZoneHandler.DAILY_CHECKS);
    }
}

