/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.entity.types;

import java.util.Objects;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Illager;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Zombie;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.ReflectionUtils;

public class KingdomEntity {
    private final @NonNull Entity entity;
    private final @NonNull Kingdom kingdom;
    private @Nullable Entity target;

    public KingdomEntity(@NonNull Entity entity, @NonNull Kingdom kingdom, @Nullable LivingEntity target) {
        this.entity = Objects.requireNonNull(entity, "Kingdom entity cannot be null");
        this.kingdom = Objects.requireNonNull(kingdom, "Kingdom entity's kingdom cannot be null");
        this.target = target;
        this.protect();
    }

    public @NonNull Entity getEntity() {
        return this.entity;
    }

    public @NonNull Kingdom getKingdom() {
        return this.kingdom;
    }

    public @Nullable Entity getTarget() {
        return this.target;
    }

    public void setTarget(@Nullable Entity target) {
        this.target = target;
    }

    void protect() {
        if (ReflectionUtils.supports(13)) {
            if (this.entity instanceof Illager) {
                ((Illager)this.entity).setPatrolLeader(false);
            }
            if (this.entity instanceof Zombie) {
                ((Zombie)this.entity).setConversionTime(Integer.MAX_VALUE);
            }
        }
    }
}

