/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.events.general.KingdomDisbandEvent;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InteractiveGUIManager;

public final class KingdomItemGUIProtection
implements Listener {
    public static final Map<SimpleLocation, CopyOnWriteArrayList<Player>> OPENED_GUI = new HashMap<SimpleLocation, CopyOnWriteArrayList<Player>>();
    public static final Map<Player, SimpleLocation> OPENED_GUI_PLAYER = new HashMap<Player, SimpleLocation>();

    protected static boolean removeLandManager(Player player) {
        SimpleLocation loc = OPENED_GUI_PLAYER.remove(player);
        if (loc != null) {
            List players = OPENED_GUI.get(loc);
            if (players != null) {
                players.remove(player);
                if (players.isEmpty()) {
                    OPENED_GUI.remove(loc);
                }
            }
            return true;
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomDisband(KingdomDisbandEvent event) {
        Kingdom kingdom = event.getKingdom();
        for (Player member : kingdom.getOnlineMembers()) {
            if (!KingdomItemGUIProtection.end(member, true)) continue;
            member.closeInventory();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onLeave(KingdomLeaveEvent event) {
        Player player = event.getPlayer().getPlayer();
        if (player != null && KingdomItemGUIProtection.end(player, true)) {
            player.closeInventory();
        }
    }

    private static boolean end(Player player, boolean onlyIfActiveLand) {
        if (!KingdomItemGUIProtection.removeLandManager(player) && onlyIfActiveLand) {
            return false;
        }
        InteractiveGUI gui = InteractiveGUIManager.getGuis().remove(player.getEntityId());
        if (gui != null) {
            gui.cancelRefreshTask();
        }
        return true;
    }
}

