/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.claiming;

import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;

public abstract class AbstractClaimProcessor {
    protected final MessageBuilder contextHolder = new MessageBuilder();
    protected final SimpleChunkLocation chunk;
    protected KingdomsLang issue;
    protected final KingdomPlayer kp;
    protected final Kingdom kingdom;
    protected boolean auto;
    protected long rp;
    protected double money;

    public AbstractClaimProcessor(SimpleChunkLocation chunk, KingdomPlayer kp, Kingdom kingdom) {
        this.chunk = Objects.requireNonNull(chunk, "Cannot process null chunk");
        this.kp = Objects.requireNonNull(kp, "Player performer cannot be null");
        this.kingdom = Objects.requireNonNull(kingdom, "Kingdom cannot be null");
        this.contextHolder.withContext(kp.getOfflinePlayer());
        this.var("x", chunk.getX());
        this.var("z", chunk.getZ());
    }

    public void asAuto() {
        this.auto = true;
    }

    public abstract AbstractClaimProcessor recompile();

    protected final void var(String variable, Object replacement) {
        this.contextHolder.raw(variable, replacement);
    }

    protected abstract KingdomsLang checkConstants();

    protected abstract KingdomsLang processIssue();

    public abstract AbstractClaimProcessor process();

    public void finalizeRequest() {
        if (this.kp.isAdmin()) {
            return;
        }
        if (this.money != 0.0) {
            this.kingdom.addBank(this.money);
        }
        if (this.rp != 0L) {
            this.kingdom.addResourcePoints(this.rp);
        }
    }

    public boolean isSuccessful() {
        return this.issue == null;
    }

    public long getResourcePoints() {
        return this.rp;
    }

    public double getMoney() {
        return this.money;
    }

    public MessageBuilder getContextHolder() {
        return this.contextHolder;
    }

    public KingdomsLang getIssue() {
        return this.issue;
    }

    public void sendIssue(CommandSender sender) {
        this.issue.sendError(sender, this.contextHolder);
    }

    public Kingdom getKingdom() {
        return this.kingdom;
    }

    public SimpleChunkLocation getChunk() {
        return this.chunk;
    }
}

