/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.holograms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.internal.integer.IntHashMap;
import org.kingdoms.utils.nms.EntityFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u000fR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/managers/land/holograms/TemporaryHologramProcessor;", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/kingdoms/constants/land/abstraction/KingdomItem;", "removeAfter", "", "(Lorg/bukkit/entity/Player;Lorg/kingdoms/constants/land/abstraction/KingdomItem;J)V", "holograms", "", "Lorg/bukkit/entity/ArmorStand;", "removalTask", "Lorg/bukkit/scheduler/BukkitTask;", "removeHolograms", "", "renewRemovalTask", "Companion", "core"})
public final class TemporaryHologramProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Player player;
    private final long removeAfter;
    @NotNull
    private final List<ArmorStand> holograms;
    @Nullable
    private BukkitTask removalTask;
    @JvmField
    @NotNull
    public static final IntHashMap<Map<SimpleLocation, TemporaryHologramProcessor>> TEMPORARY_HOLOGRAMS = new IntHashMap();

    public TemporaryHologramProcessor(@NotNull Player player, @NotNull KingdomItem<?> item, long removeAfter) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.player = player;
        this.removeAfter = removeAfter;
        Land land = item.getLand();
        Intrinsics.checkNotNull((Object)land);
        Kingdom kingdom = land.getKingdom();
        Intrinsics.checkNotNull((Object)kingdom);
        List<ArmorStand> list2 = item.spawnHolograms(kingdom, CollectionsKt.listOf((Object)this.player));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"item.spawnHolograms(item\u2026ingdom!!, listOf(player))");
        this.holograms = list2;
        this.renewRemovalTask();
    }

    public final void renewRemovalTask() {
        BukkitTask bukkitTask = this.removalTask;
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.removalTask = Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Kingdoms.get(), () -> TemporaryHologramProcessor.renewRemovalTask$lambda-0(this), this.removeAfter);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeHolograms() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.holograms;
        Collection collection = CollectionsKt.listOf((Object)this.player);
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ArmorStand armorStand = (ArmorStand)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getEntityId());
        }
        EntityFactory.removeEntity(collection, (List)destination$iv$iv);
    }

    private static final void renewRemovalTask$lambda-0(TemporaryHologramProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.removeHolograms();
    }

    @JvmStatic
    public static final void cancel(@NotNull Player player) {
        Companion.cancel(player);
    }

    @JvmStatic
    public static final void spawn(@NotNull Player player, @NotNull KingdomItem<?> item) {
        Companion.spawn(player, item);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0007R\"\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/managers/land/holograms/TemporaryHologramProcessor$Companion;", "", "()V", "TEMPORARY_HOLOGRAMS", "Lorg/kingdoms/utils/internal/integer/IntHashMap;", "", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "Lorg/kingdoms/managers/land/holograms/TemporaryHologramProcessor;", "cancel", "", "player", "Lorg/bukkit/entity/Player;", "spawn", "item", "Lorg/kingdoms/constants/land/abstraction/KingdomItem;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void cancel(@NotNull Player player) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Map<SimpleLocation, TemporaryHologramProcessor> map = TEMPORARY_HOLOGRAMS.remove(player.getEntityId());
                if (map == null) break block1;
                Map<SimpleLocation, TemporaryHologramProcessor> it = map;
                boolean bl = false;
                Iterable $this$forEach$iv = it.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TemporaryHologramProcessor x = (TemporaryHologramProcessor)element$iv;
                    boolean bl2 = false;
                    BukkitTask bukkitTask = x.removalTask;
                    Intrinsics.checkNotNull((Object)bukkitTask);
                    bukkitTask.cancel();
                }
            }
        }

        @JvmStatic
        public final void spawn(@NotNull Player player, @NotNull KingdomItem<?> item) {
            Map map;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(item, (String)"item");
            if (!((KingdomItemStyle)item.getStyle()).hideHolograms()) {
                return;
            }
            Long l = KingdomsConfig.Turrets.TEMPORARY_HOLOGRAM_DISPLAY.getManager().getTime(new PlaceholderContextBuilder().withContext(player));
            if (l == null) {
                return;
            }
            long time = l;
            Map map2 = TEMPORARY_HOLOGRAMS.get(player.getEntityId());
            if (map2 == null) {
                Companion $this$spawn_u24lambda_u2d2 = this;
                boolean bl = false;
                HashMap newMap = new HashMap();
                TEMPORARY_HOLOGRAMS.put(player.getEntityId(), newMap);
                map = newMap;
            } else {
                map = map2;
            }
            Map itemHologramList = map;
            TemporaryHologramProcessor holograms = itemHologramList.get(item.getLocation());
            if (holograms == null) {
                Map map3 = itemHologramList;
                SimpleLocation simpleLocation = item.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)simpleLocation, (String)"item.location");
                SimpleLocation simpleLocation2 = simpleLocation;
                TemporaryHologramProcessor temporaryHologramProcessor = new TemporaryHologramProcessor(player, item, time);
                map3.put(simpleLocation2, temporaryHologramProcessor);
            } else {
                holograms.renewRemovalTask();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

