/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.protectionsign;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.OpenProtectedBlockEvent;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.chat.ChatInputHandler;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.managers.protectionsign.ProtectionSignGUIManager;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.internal.ExpirableSet;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class ProtectionSignManager
implements Listener {
    private static final ExpirableSet<UUID> PASSWORD_COOLDOWNS;
    private static final Map<UUID, Integer> PASSWORD_ATTEMPTS;

    public ProtectionSignManager(Kingdoms plugin) {
        if (ItemTransferFactory.DISALLOW_ALL || ItemTransferFactory.DISALLOW_CROSS_ORIGIN) {
            Bukkit.getPluginManager().registerEvents((Listener)new ItemTransferFactory(), (Plugin)plugin);
        }
    }

    protected static Block putSignOn(Block block, XMaterial signMaterial, BlockFace facing) {
        String name = StringUtils.replace(signMaterial.name(), "SIGN", "WALL_SIGN");
        signMaterial = XMaterial.matchXMaterial(name).orElseThrow(() -> new IllegalArgumentException("Unexpected sign material for protection: " + name));
        block = block.getRelative(facing);
        block.setType(signMaterial.parseMaterial());
        VersionSupport.putSign(block, facing);
        return block;
    }

    private static boolean canBeDouble(Block block) {
        return block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST;
    }

    public static void handleProtectedBlock(PlayerInteractEvent event, ProtectionSign protection) {
        Block block;
        boolean canOpen;
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        boolean admin = KingdomsPluginPermission.PROTECTION$SIGNS_OPEN.hasPermission((CommandSender)player, true);
        ProtectionSign.AccessResult accessLevel = protection.canAccess((OfflinePlayer)player);
        boolean bl = canOpen = admin || accessLevel == ProtectionSign.AccessResult.ACCEPTED;
        if (!canOpen) {
            Land land = protection.getLand();
            boolean isClaimed = land.isClaimed();
            if (!isClaimed && !KingdomsConfig.ProtectionSigns.PROTECT_UNCLAIMED.getManager().getBoolean()) {
                canOpen = true;
            }
            if (!canOpen && isClaimed) {
                boolean bl2 = canOpen = land.getKingdomId().equals(kp.getKingdomId()) && kp.hasPermission(StandardKingdomPermission.PROTECTION_SIGNS);
            }
        }
        if (ProtectionSign.isSign(block = event.getClickedBlock()) && KingdomsConfig.ProtectionSigns.GUI.getManager().getBoolean()) {
            if (admin || protection.isOwner((OfflinePlayer)player)) {
                ProtectionSignGUIManager.openMenu(player, protection);
            } else {
                KingdomsLang.PROTECTED_SIGNS_CANT_MODIFY.sendMessage((CommandSender)player);
                ProtectionSignManager.deniedSound(player);
                return;
            }
        }
        if (!canOpen) {
            BlockState state;
            event.setCancelled(true);
            if (accessLevel == ProtectionSign.AccessResult.PASSWORD && (state = block.getState()) instanceof Container) {
                ProtectionSignManager.requestPassword(player, protection, (Container)state);
                return;
            }
            KingdomsLang.PROTECTED_SIGNS_PROTECTED.sendMessage((CommandSender)player);
            ProtectionSignManager.deniedSound(player);
        }
        OpenProtectedBlockEvent openEvent = new OpenProtectedBlockEvent(player, block, protection, canOpen);
        Bukkit.getPluginManager().callEvent((Event)openEvent);
        if (openEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }

    private static void handlePistons(BlockPistonEvent event, Collection<Block> blocks) {
        boolean protect = KingdomsConfig.ProtectionSigns.PROTECTIONS_PISTON.getManager().getBoolean();
        for (Block block : blocks) {
            Optional<ProtectionSign> protectionOpt = ProtectionSign.getProtection(block);
            if (!protectionOpt.isPresent()) continue;
            if (protect) {
                event.setCancelled(true);
                return;
            }
            ProtectionSign protection = protectionOpt.get();
            protection.getLand().getProtectedBlocks().remove(protection.getLocation());
        }
    }

    private static boolean handleAlreadyProtected(Player player, Block block) {
        Optional<ProtectionSign> protectionOpt = ProtectionSign.getProtection(block);
        if (protectionOpt.isPresent()) {
            KingdomsLang.PROTECTED_SIGNS_ALREADY_PROTECTED.sendMessage((CommandSender)player, "owner", Bukkit.getOfflinePlayer((UUID)protectionOpt.get().getOwner()).getName());
            ProtectionSignManager.deniedSound(player);
            return true;
        }
        return false;
    }

    private static void deniedSound(Player player) {
        XSound.play(player, KingdomsConfig.ProtectionSigns.DENIED_SOUND.getManager().getString());
    }

    public static void requestPassword(Player player, ProtectionSign sign, Container container) {
        long cd = PASSWORD_COOLDOWNS.getTimeLeft(player.getUniqueId());
        if (cd > 0L) {
            KingdomsLang.PROTECTED_SIGNS_PASSWORD_IN_COOLDOWN.sendError((CommandSender)player, "cooldown", TimeFormatter.of(cd));
            return;
        }
        KingdomsLang.PROTECTED_SIGNS_PASSWORD_REQUIRED.sendError((CommandSender)player, new Object[0]);
        ChatInputHandler handler = new ChatInputHandler();
        handler.onInput(event -> {
            if (sign.verifyPassword(event.getMessage())) {
                Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> player.openInventory(container.getInventory()));
                sign.getTemporarilyTrusted().add(player.getUniqueId());
                PASSWORD_ATTEMPTS.remove(player.getUniqueId());
                return true;
            }
            int maxAttempts = KingdomsConfig.ProtectionSigns.PASSWORDS_MAX_ATTEMPTS.getManager().getInt();
            int attempts = PASSWORD_ATTEMPTS.getOrDefault(player.getUniqueId(), 0) + 1;
            if (attempts >= maxAttempts) {
                KingdomsLang.PROTECTED_SIGNS_PASSWORD_ERROR_429.sendError((CommandSender)player, new Object[0]);
                PASSWORD_COOLDOWNS.add(player.getUniqueId());
                return true;
            }
            KingdomsLang.PROTECTED_SIGNS_PASSWORD_INVALID.sendError((CommandSender)player, new Object[0]);
            PASSWORD_ATTEMPTS.put(player.getUniqueId(), attempts);
            return false;
        });
        handler.onAnyMove(event -> {
            KingdomsLang.PROTECTED_SIGNS_PASSWORD_CANT_MOVE.sendError((CommandSender)player, new Object[0]);
            return true;
        });
        ChatInputManager.startConversation(player, handler);
    }

    public static List<String> getProtectionTypeSignLines(ProtectionSign.ProtectionType protectionType) {
        switch (protectionType) {
            case PROTECTED: {
                return KingdomsConfig.ProtectionSigns.LINES.getManager().getStringList();
            }
            case EVERYONE: {
                return KingdomsConfig.ProtectionSigns.EVERYONE_LINES.getManager().getStringList();
            }
            case EVERYONE_IN_KINGDOM: {
                return KingdomsConfig.ProtectionSigns.EVERYONE_IN_KINGDOM_LINES.getManager().getStringList();
            }
        }
        throw new AssertionError((Object)("Unknown sign protection type: " + (Object)((Object)protectionType)));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onSignPut(SignChangeEvent event) {
        String line = event.getLine(0);
        ProtectionSign.ProtectionType protectionType = null;
        boolean caseSensitive = KingdomsConfig.ProtectionSigns.CASE_SENSITIVE_CODES.getManager().getBoolean();
        if (!caseSensitive) {
            line = line.toLowerCase();
        }
        if (KingdomsConfig.ProtectionSigns.CODES.getManager().getStringList().contains(line)) {
            protectionType = ProtectionSign.ProtectionType.PROTECTED;
        }
        if (protectionType == null && KingdomsConfig.ProtectionSigns.EVERYONE_IN_KINGDOM_ENABLED.getManager().getBoolean() && KingdomsConfig.ProtectionSigns.EVERYONE_IN_KINGDOM_CODES.getManager().getStringList().contains(line)) {
            protectionType = ProtectionSign.ProtectionType.EVERYONE_IN_KINGDOM;
        }
        if (protectionType == null && KingdomsConfig.ProtectionSigns.EVERYONE_ENABLED.getManager().getBoolean() && KingdomsConfig.ProtectionSigns.EVERYONE_CODES.getManager().getStringList().contains(line)) {
            protectionType = ProtectionSign.ProtectionType.EVERYONE;
        }
        if (protectionType == null) {
            return;
        }
        Block sign = event.getBlock();
        Block block = VersionSupport.getAttachedBlock(sign);
        Player player = event.getPlayer();
        if (block == null) {
            KingdomsLang.PROTECTED_SIGNS_NOT_ATTACHED.sendMessage((CommandSender)player);
            ProtectionSignManager.deniedSound(player);
            return;
        }
        if (!ProtectionSign.canBlockBeProtected(block)) {
            KingdomsLang.PROTECTED_SIGNS_INVALID_BLOCK.sendMessage((CommandSender)player);
            ProtectionSignManager.deniedSound(player);
            return;
        }
        List<String> signs = KingdomsConfig.ProtectionSigns.SIGNS.getManager().getStringList();
        if (!signs.isEmpty() && !XBlock.isOneOf(block, signs)) {
            KingdomsLang.PROTECTED_SIGNS_INVALID_SIGN.sendMessage((CommandSender)player);
            ProtectionSignManager.deniedSound(player);
            return;
        }
        if (ProtectionSignManager.handleAlreadyProtected(player, block)) {
            return;
        }
        SimpleLocation location = SimpleLocation.of(block);
        Land land = Land.getLand(block);
        if (land == null || !land.isClaimed()) {
            if (!KingdomsConfig.ProtectionSigns.PROTECT_UNCLAIMED.getManager().getBoolean()) {
                KingdomsLang.PROTECTED_SIGNS_UNCLAIMED.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (land == null) {
                land = new Land((UUID)null, location.toSimpleChunkLocation());
            }
        }
        if (land.getTurrets().containsKey(location) || land.getStructures().containsKey(location)) {
            KingdomsLang.PROTECTED_SIGNS_KINGDOM_ITEMS.sendError((CommandSender)player, new Object[0]);
            return;
        }
        List<String> lines = ProtectionSignManager.getProtectionTypeSignLines(protectionType);
        ProtectionSign.placeProtection(land, block, sign, player, protectionType);
        MessageBuilder settings = new MessageBuilder().withContext(player);
        for (int i = 0; i < lines.size(); ++i) {
            event.setLine(i, MessageCompiler.compile(lines.get(i)).buildPlain(settings));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onProtectedBreak(BlockBreakEvent event) {
        boolean admin;
        Block block = event.getBlock();
        Optional<ProtectionSign> protectionOpt = ProtectionSign.getProtection(block);
        if (!protectionOpt.isPresent()) {
            return;
        }
        ProtectionSign protection = protectionOpt.get();
        boolean isSign = protection.getSign().equals(SimpleLocation.of(block));
        if (!isSign && ProtectionSign.isSign(block)) {
            return;
        }
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        boolean bl = admin = kp.isAdmin() || kp.hasKingdom() && kp.getKingdomId().equals(protection.getLand().getKingdomId()) && kp.hasPermission(StandardKingdomPermission.PROTECTION_SIGNS) || KingdomsPluginPermission.PROTECTION$SIGNS_BREAK.hasPermission((CommandSender)player, true);
        if (admin || protection.canAccess((OfflinePlayer)player) == ProtectionSign.AccessResult.ACCEPTED) {
            if (admin || protection.getOwner().equals(player.getUniqueId())) {
                if (isSign) {
                    KingdomsLang.PROTECTED_SIGNS_UNPROTECTED.sendMessage((CommandSender)player);
                } else {
                    KingdomsLang.PROTECTED_SIGNS_BROKE.sendMessage((CommandSender)player);
                }
                if (isSign || protection.shouldRemoveProtectionAfterBreak(block)) {
                    protection.removeProtection();
                }
            } else {
                KingdomsLang.PROTECTED_SIGNS_CANT_BREAK.sendMessage((CommandSender)player);
                ProtectionSignManager.deniedSound(player);
                event.setCancelled(true);
            }
        } else {
            KingdomsLang.PROTECTED_SIGNS_PROTECTED.sendMessage((CommandSender)player);
            ProtectionSignManager.deniedSound(player);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        ProtectionSignManager.handlePistons((BlockPistonEvent)event, event.getBlocks());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        ProtectionSignManager.handlePistons((BlockPistonEvent)event, event.getBlocks());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void doubleChestProtectNotifier(BlockPlaceEvent event) {
        if (!ProtectionSignManager.canBeDouble(event.getBlockPlaced())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
            Block block = event.getBlockPlaced();
            if (!(block.getState() instanceof Chest)) {
                return;
            }
            Chest chest = (Chest)block.getState();
            Inventory inventory = chest.getInventory();
            if (inventory instanceof DoubleChestInventory) {
                DoubleChest doubleChest = (DoubleChest)inventory.getHolder();
                Chest leftChest = (Chest)doubleChest.getLeftSide();
                Chest rightChest = (Chest)doubleChest.getRightSide();
                Block target = rightChest.getBlock();
                if (LocationUtils.equalsIgnoreWorld(block, target)) {
                    target = leftChest.getBlock();
                }
                if (ProtectionSign.isProtected(target)) {
                    Land otherLand;
                    SimpleChunkLocation mainChunk;
                    SimpleChunkLocation otherChunk;
                    if (!(KingdomsConfig.ProtectionSigns.PROTECT_UNCLAIMED.getManager().getBoolean() || (otherChunk = SimpleChunkLocation.of(block)).equalsIgnoreWorld(mainChunk = SimpleChunkLocation.of(target)) || (otherLand = otherChunk.getLand()) != null && otherLand.isClaimed())) {
                        KingdomsLang.PROTECTED_SIGNS_CANT_PROTECT_DOUBLE_CHEST.sendError((CommandSender)event.getPlayer(), new Object[0]);
                        return;
                    }
                    KingdomsLang.PROTECTED_SIGNS_DOUBLE_CHEST_PROTECTED.sendMessage((CommandSender)event.getPlayer());
                }
            }
        }, 1L);
    }

    @EventHandler
    public void onQuickProtect(PlayerInteractEvent event) {
        Kingdom kingdom;
        boolean isCreative;
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (event.getBlockFace() == BlockFace.UP || event.getBlockFace() == BlockFace.DOWN) {
            return;
        }
        if (!KingdomsConfig.ProtectionSigns.QUICK_PROTECT_ENABLED.getManager().getBoolean()) {
            return;
        }
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!KingdomsPluginPermission.PROTECTION$SIGNS_USE.hasPermission((CommandSender)player, true)) {
            return;
        }
        boolean bl = isCreative = player.getGameMode() == GameMode.CREATIVE;
        if (isCreative && !KingdomsPluginPermission.PROTECTION$SIGNS_USE_CREATIVE.hasPermission((CommandSender)player, true)) {
            return;
        }
        if (!player.isSneaking() && KingdomsConfig.ProtectionSigns.QUICK_PROTECT_SNEAK.getManager().getBoolean()) {
            return;
        }
        ItemStack itemSign = event.getItem();
        if (itemSign == null || !itemSign.getType().name().endsWith("SIGN")) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!ProtectionSign.canBlockBeProtected(block)) {
            return;
        }
        List<String> signs = KingdomsConfig.ProtectionSigns.SIGNS.getManager().getStringList();
        XMaterial material = XMaterial.matchXMaterial(itemSign);
        if (!signs.isEmpty() && !material.isOneOf(signs)) {
            KingdomsLang.PROTECTED_SIGNS_INVALID_SIGN.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
            return;
        }
        SimpleChunkLocation chunk = SimpleChunkLocation.of(block);
        Land land = chunk.getLand();
        if (land == null || !land.isClaimed()) {
            if (!KingdomsConfig.ProtectionSigns.PROTECT_UNCLAIMED.getManager().getBoolean()) {
                KingdomsLang.PROTECTED_SIGNS_UNCLAIMED.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (land == null) {
                land = new Land((UUID)null, chunk);
            }
        }
        SimpleLocation location = SimpleLocation.of(block);
        if (land.getTurrets().containsKey(location) || land.getStructures().containsKey(location)) {
            KingdomsLang.PROTECTED_SIGNS_KINGDOM_ITEMS.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (!(kp.isAdmin() || !land.isClaimed() || (kingdom = kp.getKingdom()) != null && kingdom.hasAttribute(land.getKingdom(), (RelationAttribute)StandardRelationAttribute.BUILD))) {
            KingdomsLang.PROTECTED_SIGNS_OTHER_KINGDOMS.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (ProtectionSignManager.handleAlreadyProtected(player, block)) {
            event.setCancelled(true);
            return;
        }
        Block signBlock = block.getRelative(event.getBlockFace());
        if (!LocationUtils.blockCanBeReplaced(signBlock)) {
            KingdomsLang.PROTECTED_SIGNS_INVALID_SIGN_BLOCK.sendError((CommandSender)player, new Object[]{"block", XMaterial.matchXMaterial(signBlock.getType())});
            event.setCancelled(true);
            return;
        }
        Block sign = ProtectionSignManager.putSignOn(block, material, event.getBlockFace());
        event.setCancelled(true);
        if (!isCreative) {
            itemSign.setAmount(itemSign.getAmount() - 1);
        }
        ProtectionSign.placeProtection(land, block, sign, player, ProtectionSign.ProtectionType.PROTECTED);
        List<String> lines = KingdomsConfig.ProtectionSigns.LINES.getManager().getStringList();
        Sign state = (Sign)sign.getState();
        MessageBuilder settings = new MessageBuilder().withContext(player);
        for (int i = 0; i < lines.size(); ++i) {
            state.setLine(i, MessageCompiler.compile(lines.get(i)).buildPlain(settings));
        }
        state.update(true);
    }

    static {
        PASSWORD_ATTEMPTS = new NonNullMap<UUID, Integer>();
        long cooldown = KingdomsConfig.ProtectionSigns.PASSWORDS_MAX_ATTEMPTS_COOLDOWN.getManager().getTimeMillis();
        PASSWORD_COOLDOWNS = new ExpirableSet(cooldown, TimeUnit.MILLISECONDS, false);
    }

    public static final class ItemTransferFactory
    implements Listener {
        private static final boolean DISALLOW_ALL = KingdomsConfig.ProtectionSigns.PROTECTIONS_CONTAINER_TRANSFERS_DISALLOW_ALL.getManager().getBoolean();
        private static final boolean DISALLOW_CROSS_ORIGIN = KingdomsConfig.ProtectionSigns.PROTECTIONS_CONTAINER_TRANSFERS_DISALLOW_CROSS_ORIGIN_CONTAINER_TRANSFERS.getManager().getBoolean();

        @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
        public void onProtectedTransfer(InventoryMoveItemEvent event) {
            Optional destOpt;
            Location srcLocaton = event.getSource().getLocation();
            Optional srcOpt = srcLocaton == null ? Optional.empty() : ProtectionSign.getProtection(srcLocaton.getBlock());
            Location destLocation = event.getDestination().getLocation();
            Optional<Object> optional = destOpt = destLocation == null ? Optional.empty() : ProtectionSign.getProtection(destLocation.getBlock());
            if (DISALLOW_ALL) {
                if (srcOpt.isPresent() || destOpt.isPresent()) {
                    event.setCancelled(true);
                }
                return;
            }
            if (srcOpt.isPresent() && destOpt.isPresent()) {
                boolean disallowTransfers;
                ProtectionSign src = (ProtectionSign)srcOpt.get();
                ProtectionSign dest = (ProtectionSign)destOpt.get();
                boolean bl = DISALLOW_CROSS_ORIGIN ? !src.getOwner().equals(dest.getOwner()) : (disallowTransfers = src.canAccess(dest.getOwner()) != ProtectionSign.AccessResult.ACCEPTED);
                if (disallowTransfers) {
                    event.setCancelled(true);
                }
                return;
            }
            if (srcOpt.isPresent() || destOpt.isPresent()) {
                event.setCancelled(true);
            }
        }
    }
}

