/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.structures;

import java.time.Duration;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.JailSession;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.objects.JailStructure;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.KingdomsBukkitExtensions;
import org.kingdoms.utils.cooldown.Cooldown;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/managers/structures/JailManager;", "Lorg/bukkit/event/Listener;", "()V", "onBlockBreak", "", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "onBlockPlace", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onBuild", "Lorg/bukkit/event/Cancellable;", "player", "Lorg/bukkit/entity/Player;", "onContainerOpen", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onDropItem", "Lorg/bukkit/event/player/PlayerDropItemEvent;", "onEscape", "Lorg/kingdoms/events/lands/LandChangeEvent;", "onPrisonerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "Companion", "core"})
public final class JailManager
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Cooldown<UUID> DROP_COOLDOWN = new Cooldown();

    @EventHandler
    public final void onPrisonerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        Player player2 = player;
        JailStructure jailStructure = Companion.getCell((OfflinePlayer)player2);
        if (jailStructure == null) {
            return;
        }
        JailStructure cell = jailStructure;
        JailSession jailSession = cell.getJailSession();
        Intrinsics.checkNotNull((Object)jailSession);
        JailSession session = jailSession;
        session.notifyPlayerAndTeleport(cell);
    }

    private final void onBuild(Cancellable event, Player player) {
        JailStructure jailStructure = Companion.getCell((OfflinePlayer)player);
        if (jailStructure == null) {
            return;
        }
        JailStructure cell = jailStructure;
        JailSession jailSession = cell.getJailSession();
        Intrinsics.checkNotNull((Object)jailSession);
        JailSession session = jailSession;
        if (session.getCurrentFreeHours() != null) {
            return;
        }
        new StaticMessenger("{$e}You cannot build while you're jailed and outside of free hours.").sendError((CommandSender)player, new Object[0]);
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Cancellable cancellable = (Cancellable)event;
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        this.onBuild(cancellable, player);
    }

    @EventHandler(ignoreCancelled=true)
    public final void onBlockPlace(@NotNull BlockPlaceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Cancellable cancellable = (Cancellable)event;
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        this.onBuild(cancellable, player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onEscape(@NotNull LandChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Kingdoms.taskScheduler().async().execute(() -> JailManager.onEscape$lambda-0(event));
    }

    @EventHandler(ignoreCancelled=true)
    public final void onDropItem(@NotNull PlayerDropItemEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        Player player2 = player;
        if (!JailManager.Companion.isJailed(KingdomsBukkitExtensions.INSTANCE.asKingdomPlayer((OfflinePlayer)player2))) {
            return;
        }
        event.setCancelled(true);
        boolean isInCd = DROP_COOLDOWN.isInCooldown(player2.getUniqueId());
        DROP_COOLDOWN.add(player2.getUniqueId(), Duration.ofSeconds(5L));
        if (isInCd) {
            XSound.BLOCK_FIRE_EXTINGUISH.play((Entity)player2);
            Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> JailManager.onDropItem$lambda-1(player2), 1L);
            return;
        }
        new StaticMessenger("{$e}If you drop this item, it'll be destroyed because you're jailed. If you still wish to drop it, do it again.").sendError((CommandSender)player2, new Object[0]);
    }

    @EventHandler(ignoreCancelled=true)
    public final void onContainerOpen(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        KingdomPlayer player2 = KingdomsBukkitExtensions.INSTANCE.asKingdomPlayer((OfflinePlayer)player);
        if (!JailManager.Companion.isJailed(player2)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        Intrinsics.checkNotNull((Object)block);
        switch (WhenMappings.$EnumSwitchMapping$0[XMaterial.matchXMaterial(block.getType()).ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                return;
            }
        }
        new StaticMessenger("{$e}You can't open containers while you're jailed.").sendError((CommandSender)event.getPlayer(), new Object[0]);
        event.setCancelled(true);
    }

    private static final void onEscape$lambda-0(LandChangeEvent $event) {
        Land to;
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Player player = $event.getPlayer();
        KingdomPlayer kp = $event.getKingdomPlayer();
        JailStructure jailStructure = JailManager.Companion.asJailCell(kp.getJailCell());
        if (jailStructure == null) {
            return;
        }
        JailStructure cell = jailStructure;
        Land land = to = $event.getToLand();
        Kingdom toKingdom = land != null ? land.getKingdom() : null;
        Land land2 = cell.getLand();
        Intrinsics.checkNotNull((Object)land2);
        Kingdom kingdom = land2.getKingdom();
        Intrinsics.checkNotNull((Object)kingdom);
        Kingdom cellKingdom = kingdom;
        if (!Intrinsics.areEqual((Object)toKingdom, (Object)cellKingdom)) {
            // empty if block
        }
    }

    private static final void onDropItem$lambda-1(Player $player) {
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        $player.getInventory().setItem($player.getInventory().getHeldItemSlot(), null);
    }

    @JvmStatic
    @Nullable
    public static final JailStructure getCell(@NotNull OfflinePlayer player) {
        return Companion.getCell(player);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007*\u0004\u0018\u00010\u000bH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/managers/structures/JailManager$Companion;", "", "()V", "DROP_COOLDOWN", "Lorg/kingdoms/utils/cooldown/Cooldown;", "Ljava/util/UUID;", "getCell", "Lorg/kingdoms/constants/land/structures/objects/JailStructure;", "player", "Lorg/bukkit/OfflinePlayer;", "asJailCell", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "isJailed", "", "Lorg/kingdoms/constants/player/KingdomPlayer;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final JailStructure getCell(@NotNull OfflinePlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return this.asJailCell(KingdomsBukkitExtensions.INSTANCE.asKingdomPlayer(player).getJailCell());
        }

        private final JailStructure asJailCell(SimpleLocation $this$asJailCell) {
            if ($this$asJailCell == null) {
                return null;
            }
            Object object = $this$asJailCell.toSimpleChunkLocation().getLand();
            Structure structure = object != null && (object = ((Land)object).getStructures()) != null ? (Structure)object.get($this$asJailCell) : null;
            Intrinsics.checkNotNull(structure, (String)"null cannot be cast to non-null type org.kingdoms.constants.land.structures.objects.JailStructure");
            return (JailStructure)structure;
        }

        private final boolean isJailed(KingdomPlayer $this$isJailed) {
            return $this$isJailed.getJailCell() != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[XMaterial.values().length];
            nArray[XMaterial.CHEST.ordinal()] = 1;
            nArray[XMaterial.FURNACE.ordinal()] = 2;
            nArray[XMaterial.TRAPPED_CHEST.ordinal()] = 3;
            nArray[XMaterial.BARREL.ordinal()] = 4;
            nArray[XMaterial.HOPPER.ordinal()] = 5;
            nArray[XMaterial.DISPENSER.ordinal()] = 6;
            nArray[XMaterial.DROPPER.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

