/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.structures;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.objects.SiegeCannon;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.structures.SiegeCannonHitEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.messages.ActionBar;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.ChairManager;
import org.kingdoms.managers.ChairSession;
import org.kingdoms.managers.land.protection.LandExplosionManager;
import org.kingdoms.managers.structures.SiegeCannonAmmo;
import org.kingdoms.utils.EventUtil;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.internal.integer.IntHashSet;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\r"}, d2={"Lorg/kingdoms/managers/structures/SiegeManager;", "Lorg/bukkit/event/Listener;", "()V", "onCannonDamage", "", "event", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onCannonHit", "Lorg/bukkit/event/entity/ProjectileHitEvent;", "onQuickGUIOpen", "Lorg/bukkit/event/player/PlayerArmorStandManipulateEvent;", "onShoot", "Companion", "core"})
public final class SiegeManager
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IntHashSet ARMORSTAND_RIGHT_CLICKED = new IntHashSet();
    @JvmField
    @NotNull
    public static final Cooldown<UUID> SIEGE_LAST_ATTACK = new Cooldown();

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onCannonHit(@NotNull ProjectileHitEvent event) {
        Group group;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Projectile projectile = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)projectile, (String)"event.entity");
        Projectile projectile2 = projectile;
        Pair<SiegeCannon, SiegeCannonAmmo> pair = SiegeCannon.getSiegeCannonFromProjectile((Entity)projectile2);
        if (pair == null) {
            return;
        }
        Pair<SiegeCannon, SiegeCannonAmmo> pair2 = pair;
        SiegeCannon cannon = (SiegeCannon)((Map.Entry)pair2).getKey();
        SiegeCannonAmmo ammo = (SiegeCannonAmmo)((Map.Entry)pair2).getValue();
        Location location = projectile2.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"projectile.location");
        Location location2 = location;
        cannon.displayParticle(location2, "hit");
        cannon.playSound(location2, "hit");
        Player player = cannon.getHandler();
        if (player == null) {
            return;
        }
        Player player2 = player;
        SimpleChunkLocation chunk = SimpleChunkLocation.of(location2);
        Land land = chunk.getLand();
        if (event.getHitEntity() != null && event.getHitEntity() instanceof Player) {
            Entity entity = event.getHitEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
            Player hitPlayer = (Player)entity;
            if (hitPlayer.isBlocking()) {
                PlayerInventory it = hitPlayer.getInventory();
                boolean bl = false;
                if (XMaterial.SHIELD.isSimilar(it.getItemInMainHand())) {
                    it.setItemInMainHand(null);
                } else {
                    it.setItemInOffHand(null);
                }
                hitPlayer.getInventory().setItemInOffHand(null);
                KingdomsLang.SIEGE_CANNON_HIT_PLAYERS_SHIELD.sendMessage((CommandSender)player2);
            }
        }
        long damage = cannon.getShieldDamage(ammo);
        SiegeCannonHitEvent siegeCannonHitEvent = new SiegeCannonHitEvent(cannon, event, damage);
        World world = location2.getWorld();
        Intrinsics.checkNotNull((Object)world);
        for (Object[] entity : world.getNearbyEntities(location2, 15.0, 15.0, 15.0)) {
            if (entity.getType() == EntityType.PLAYER || entity.getType() == EntityType.ARMOR_STAND) continue;
            LandExplosionManager.protectEntityFromExplosion(null, (Entity)projectile2, (Entity)entity);
        }
        if (land == null) {
            KingdomsLang.SIEGE_CANNON_HIT_UNCLAIMED_LAND.sendError((CommandSender)player2, new Object[0]);
            EventUtil.cancelAndCall((Event)siegeCannonHitEvent);
            return;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            KingdomsLang.SIEGE_CANNON_HIT_UNCLAIMED_LAND.sendError((CommandSender)player2, new Object[0]);
            EventUtil.cancelAndCall((Event)siegeCannonHitEvent);
            return;
        }
        Land land2 = cannon.getLand();
        if (!StandardRelationAttribute.INVADE.hasAttribute(kingdom, land2 != null ? land2.getKingdom() : null)) {
            Object[] entity;
            entity = new Object[]{"kingdom", kingdom.getName()};
            KingdomsLang.SIEGE_CANNON_FRIENDLY_FIRE.sendError((CommandSender)player2, entity);
            EventUtil.cancelAndCall((Event)siegeCannonHitEvent);
            return;
        }
        MessageBuilder settings = new MessageBuilder().withContext(kingdom);
        if (kingdom.isPacifist()) {
            CommandSender commandSender = (CommandSender)player2;
            Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"settings");
            KingdomsLang.SIEGE_CANNON_HIT_PACIFIST.sendMessage(commandSender, settings);
            EventUtil.cancelAndCall((Event)siegeCannonHitEvent);
            return;
        }
        if (kingdom.hasNation() && KingdomsConfig.Invasions.NATIONS_USE_SHIELD.getManager().getBoolean()) {
            Nation nation = kingdom.getNation();
            Intrinsics.checkNotNull((Object)nation);
            group = nation;
        } else {
            group = kingdom;
        }
        Group groupsShouldToUse = group;
        settings.withContext(groupsShouldToUse);
        if (groupsShouldToUse.getShieldTimeLeft() <= 0L) {
            CommandSender commandSender = (CommandSender)player2;
            Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"settings");
            KingdomsLang.SIEGE_CANNON_HIT_NO_SHIELD.sendMessage(commandSender, settings);
            EventUtil.cancelAndCall((Event)siegeCannonHitEvent);
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)siegeCannonHitEvent);
        if (siegeCannonHitEvent.isCancelled()) {
            return;
        }
        UUID uUID = kingdom.getDataKey();
        Long l = KingdomsConfig.Invasions.SHIELDS_PURCHASE_COOLDOWN_LAST_SIEGE_CANNON_HIT.getManager().getTimeMillis();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"SHIELDS_PURCHASE_COOLDOW\u2026ON_HIT.manager.timeMillis");
        SIEGE_LAST_ATTACK.add(uUID, ((Number)l).longValue());
        damage = siegeCannonHitEvent.getShieldDamage();
        if (damage >= groupsShouldToUse.getShieldTimeLeft()) {
            CommandSender commandSender = (CommandSender)player2;
            Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"settings");
            KingdomsLang.SIEGE_CANNON_HIT_DESTROYED_SHIELD.sendMessage(commandSender, settings);
            groupsShouldToUse.deactivateShield();
            return;
        }
        Kingdom kingdom2 = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player2).getKingdom();
        Intrinsics.checkNotNull((Object)kingdom2);
        Kingdom attackerKingdom = kingdom2;
        groupsShouldToUse.setShieldTime(groupsShouldToUse.getShieldTime() - damage);
        CommandSender commandSender = (CommandSender)player2;
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"settings");
        KingdomsLang.SIEGE_CANNON_HIT_DAMAGED_SHIELD.sendMessage(commandSender, settings);
        for (Player member : kingdom.getOnlineMembers()) {
            Object[] objectArray = new Object[8];
            objectArray[0] = "attacker-kingdom";
            objectArray[1] = attackerKingdom.getName();
            objectArray[2] = "attacker";
            objectArray[3] = player2.getName();
            objectArray[4] = "attacked-chunk";
            Object[] objectArray2 = LocationUtils.getChunkEdits(chunk);
            objectArray[5] = KingdomsLang.LOCATIONS_CHUNK.parse(Arrays.copyOf(objectArray2, objectArray2.length));
            objectArray[6] = "attackers-chunk";
            objectArray2 = LocationUtils.getChunkEdits(SimpleChunkLocation.of(player2.getLocation()));
            objectArray[7] = KingdomsLang.LOCATIONS_CHUNK.parse(Arrays.copyOf(objectArray2, objectArray2.length));
            KingdomsLang.SIEGE_CANNON_HIT_DAMAGED_SHIELD_NOTIFY.sendMessage((CommandSender)member, objectArray);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public final void onCannonDamage(@NotNull EntityDamageByEntityEvent event) {
        Kingdom shooterKingdom;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SiegeManager $this$onCannonDamage_u24lambda_u2d1 = this;
        boolean bl = false;
        Pair<SiegeCannon, SiegeCannonAmmo> cannon = SiegeCannon.getSiegeCannonFromProjectile(event.getEntity());
        if (cannon != null) {
            event.setCancelled(true);
            return;
        }
        Pair<SiegeCannon, SiegeCannonAmmo> pair = SiegeCannon.getSiegeCannonFromProjectile(event.getDamager());
        if (pair == null) {
            return;
        }
        Pair<SiegeCannon, SiegeCannonAmmo> pair2 = pair;
        SiegeCannon cannon2 = (SiegeCannon)((Map.Entry)pair2).getKey();
        SiegeCannonAmmo ammo = (SiegeCannonAmmo)((Map.Entry)pair2).getValue();
        Entity entity = event.getEntity();
        Player player = entity instanceof Player ? (Player)entity : null;
        if (player == null) {
            return;
        }
        Player victim = player;
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)victim);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(victim)");
        KingdomPlayer kp = kingdomPlayer;
        Kingdom kingdom = kp.getKingdom();
        Land land = cannon2.getLand();
        Kingdom kingdom2 = shooterKingdom = land != null ? land.getKingdom() : null;
        if (StandardRelationAttribute.CEASEFIRE.hasAttribute(kingdom, shooterKingdom)) {
            event.setCancelled(true);
        }
        event.setDamage(cannon2.getDamage(ammo));
        PlayerUtils.damageArmor((LivingEntity)victim, (int)cannon2.getArmorDamage(ammo));
        double knockback = cannon2.getKnockBack(ammo);
        LocationUtils.knockback(cannon2.getLocation().toVector(), (Entity)victim, knockback, 0.0);
    }

    @EventHandler
    public final void onShoot(@NotNull EntityDamageByEntityEvent event) {
        String actionbar;
        String[] stringArray;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getDamager();
        Player player = entity instanceof Player ? (Player)entity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (ARMORSTAND_RIGHT_CLICKED.remove(player2.getEntityId())) {
            return;
        }
        ChairManager.Companion this_$iv = ChairManager.Companion;
        boolean $i$f$get = false;
        ChairSession<Object> chairSession = this_$iv.getHandler((Entity)player2);
        if (chairSession == null) {
            object2 = null;
        } else {
            ChairSession<Object> session$iv = chairSession;
            if (session$iv.getSession() instanceof SiegeCannon) {
                Intrinsics.checkNotNull(session$iv, (String)"null cannot be cast to non-null type org.kingdoms.managers.ChairSession<T of org.kingdoms.managers.ChairManager.Companion.get>");
                object2 = session$iv;
            } else {
                object2 = object = null;
            }
        }
        if (object2 == null || (object = (SiegeCannon)((ChairSession)object).getSession()) == null) {
            return;
        }
        Object cannon = object;
        event.setCancelled(true);
        if (!((SiegeCannon)cannon).isLoaded()) {
            stringArray = new String[]{"actionbar", "not-loaded"};
            actionbar = ((StructureStyle)((KingdomItem)cannon).getStyle()).getOption(stringArray).getString();
            actionbar = MessageCompiler.compile(actionbar).buildPlain(new MessageBuilder().withContext(player2));
            ActionBar.sendActionBar((Plugin)Kingdoms.get().getLoader(), player2, actionbar);
            ((KingdomItem)cannon).playSound("empty");
            return;
        }
        if (((SiegeCannon)cannon).isInCooldown()) {
            ((KingdomItem)cannon).playSound("cooldown");
            return;
        }
        stringArray = new String[]{"actionbar", "fire"};
        actionbar = ((StructureStyle)((KingdomItem)cannon).getStyle()).getOption(stringArray).getString();
        actionbar = MessageCompiler.compile(actionbar).buildPlain(new MessageBuilder().withContext(player2));
        ActionBar.sendActionBar((Plugin)Kingdoms.get().getLoader(), player2, actionbar);
        ((SiegeCannon)cannon).shoot();
    }

    @EventHandler(ignoreCancelled=true)
    public final void onQuickGUIOpen(@NotNull PlayerArmorStandManipulateEvent event) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        Player player2 = player;
        ChairManager.Companion this_$iv = ChairManager.Companion;
        boolean $i$f$get = false;
        ChairSession<Object> chairSession = this_$iv.getHandler((Entity)player2);
        if (chairSession == null) {
            object2 = null;
        } else {
            ChairSession<Object> session$iv = chairSession;
            if (session$iv.getSession() instanceof SiegeCannon) {
                Intrinsics.checkNotNull(session$iv, (String)"null cannot be cast to non-null type org.kingdoms.managers.ChairSession<T of org.kingdoms.managers.ChairManager.Companion.get>");
                object2 = session$iv;
            } else {
                object2 = object = null;
            }
        }
        if (object2 == null || (object = (SiegeCannon)((ChairSession)object).getSession()) == null) {
            return;
        }
        Object cannon = object;
        event.setCancelled(true);
        ARMORSTAND_RIGHT_CLICKED.add(player2.getEntityId());
        PlayerInteractEvent interactEvent = new PlayerInteractEvent(player2, Action.RIGHT_CLICK_BLOCK, null, null, BlockFace.SELF);
        KingdomItemInteractEvent<KingdomItem> structureInteractEvent = new KingdomItemInteractEvent<KingdomItem>(interactEvent, Land.getLand(event.getRightClicked().getLocation()), (KingdomItem)cannon);
        ((StructureType)((StructureStyle)((KingdomItem)cannon).getStyle()).getType()).open(new KingdomItemGUIContext<KingdomItem>(structureInteractEvent));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kingdoms/managers/structures/SiegeManager$Companion;", "", "()V", "ARMORSTAND_RIGHT_CLICKED", "Lorg/kingdoms/utils/internal/integer/IntHashSet;", "SIEGE_LAST_ATTACK", "Lorg/kingdoms/utils/cooldown/Cooldown;", "Ljava/util/UUID;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

