/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.teleportation;

import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.teleportation.TeleportTask;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.internal.integer.IntHashMap;

public final class TpManager
implements Listener {
    private static final IntHashMap<TeleportTask> TELEPORTING = new IntHashMap();

    public static void put(Player player, BukkitTask task) {
        TpManager.put(new TeleportTask(player, task));
    }

    public static void put(TeleportTask task) {
        TeleportTask previous = TELEPORTING.put(task.player.getEntityId(), task);
        if (previous != null) {
            previous.task.cancel();
        }
    }

    public static boolean end(Entity entity) {
        TeleportTask task = TELEPORTING.remove(entity.getEntityId());
        if (task != null) {
            task.task.cancel();
        }
        return task != null;
    }

    public static void cancelAll(Collection<Entity> entities) {
        for (Entity entity : entities) {
            TpManager.end(entity);
        }
    }

    public static boolean isTeleporting(Entity entity) {
        return TELEPORTING.containsKey(entity.getEntityId());
    }

    public static boolean alreadyTping(Player player) {
        if (TpManager.isTeleporting((Entity)player)) {
            KingdomsLang.TELEPORTS_ALREADY_TELEPORTING.sendError((CommandSender)player, new Object[0]);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        TELEPORTING.remove(event.getPlayer().getEntityId());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        int id = event.getEntity().getEntityId();
        TeleportTask task = TELEPORTING.remove(id);
        if (task != null && task.onDamage != null) {
            task.onDamage.apply(event);
            task.task.cancel();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onMove(PlayerMoveEvent event) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            if (!LocationUtils.hasMoved(event.getFrom(), event.getTo())) {
                return;
            }
            int id = event.getPlayer().getEntityId();
            TeleportTask task = TELEPORTING.remove(id);
            if (task != null && task.onMove != null) {
                task.onMove.apply(event);
                task.task.cancel();
            }
        });
    }
}

