/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.turrets;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.MineTurret;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.turrets.TurretTask;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cache.CacheHandler;
import org.kingdoms.utils.internal.integer.IntHashMap;

public final class TurretFactory
implements Listener {
    public static final Cache<Integer, TurretActivateEvent> DAMAGED = CacheHandler.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    protected static final Map<SimpleChunkLocation, Land> TURRET_LANDS = new ConcurrentHashMap<SimpleChunkLocation, Land>(100);
    protected static final IntHashMap<BukkitTask> INVULNERABLE = new IntHashMap();
    private static final long UPDATE_TICKS;
    private static final long DELAYED_SERVICE_START = 600L;
    private static boolean disabled;

    public static boolean isDisabled() {
        return disabled;
    }

    public static void setDisabled(boolean disable) {
        disabled = disable;
    }

    public static Map<SimpleChunkLocation, Land> getTurretLands() {
        return TURRET_LANDS;
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile entity = event.getEntity();
        if (event.getHitBlock() != null && entity.hasMetadata("TURRET_ORIGIN")) {
            entity.remove();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onTurretDamage(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)event.getEntity();
        Entity damager = event.getDamager();
        List meta = damager.getMetadata("TURRET_ORIGIN");
        if (meta.isEmpty()) {
            DAMAGED.invalidate((Object)entity.getEntityId());
            return;
        }
        Turret turret = (Turret)((MetadataValue)meta.get(0)).value();
        Land land = turret.getLand();
        if (land == null) {
            return;
        }
        Kingdom kingdom = (Kingdom)((MetadataValue)damager.getMetadata("TURRET_KINGDOM").get(0)).value();
        if (turret.getLastActivation().getTarget() != entity) {
            Kingdom owningEntityKingdom;
            if (entity instanceof Player) {
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(entity.getUniqueId());
                owningEntityKingdom = kp.getKingdom();
            } else {
                Land entityLand = Land.getLand(entity.getLocation());
                owningEntityKingdom = entityLand == null ? null : entityLand.getKingdom();
            }
            boolean friendly = owningEntityKingdom != null && owningEntityKingdom.hasAttribute(kingdom, (RelationAttribute)StandardRelationAttribute.TURRET_CEASEFIRE);
            List<String> list2 = (friendly ? KingdomsConfig.Turrets.DISALLOW_ACCIDENTAL_MOB_DAMAGE_FRIENDLY : KingdomsConfig.Turrets.DISALLOW_ACCIDENTAL_MOB_DAMAGE_OTHERS).getManager().getStringList();
            if (list2.contains(entity.getType().name())) {
                event.setCancelled(true);
                return;
            }
        }
        turret.activate(entity, kingdom);
        event.setDamage(turret.getDamage(kingdom));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTeleport(PlayerTeleportEvent event) {
        int seconds = KingdomsConfig.Turrets.TELEPORTATION_INVULNERABILITY.getManager().getInt();
        if (seconds <= 0) {
            return;
        }
        final int id = event.getPlayer().getEntityId();
        BukkitTask last = INVULNERABLE.put(id, new BukkitRunnable(){

            public void run() {
                INVULNERABLE.remove(id);
            }
        }.runTaskLater((Plugin)Kingdoms.get(), (long)seconds * 20L));
        if (last != null) {
            last.cancel();
        }
    }

    @EventHandler
    public void onTurretDropEXP(EntityDeathEvent event) {
        if (event.getEntityType() == EntityType.PLAYER) {
            return;
        }
        if (event.getDroppedExp() != 0) {
            return;
        }
        LivingEntity entity = event.getEntity();
        TurretActivateEvent turretEvent = (TurretActivateEvent)DAMAGED.getIfPresent((Object)entity.getEntityId());
        if (turretEvent == null) {
            return;
        }
        ConfigAccessor exp = ((TurretStyle)turretEvent.getTurret().getStyle()).getOption("dropped-exp").getSection();
        if (exp == null) {
            return;
        }
        String eqn = exp.getString(entity.getType().name());
        if (eqn == null) {
            return;
        }
        event.setDroppedExp((int)MathUtils.eval(eqn, turretEvent.getKingdom(), new Object[0]));
    }

    @EventHandler
    public void onTurretDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        TurretActivateEvent turretEvent = (TurretActivateEvent)DAMAGED.getIfPresent((Object)player.getEntityId());
        if (turretEvent == null) {
            return;
        }
        Turret turret = turretEvent.getTurret();
        String deathMsg = turret.chooseDeathMessage();
        if (deathMsg == null) {
            return;
        }
        event.setDeathMessage(null);
        MessageBuilder settings = turret.getEdits(turretEvent.getKingdom()).withContext(player).other(turretEvent.getKingdom());
        MessageProvider msg = MessageCompiler.compile(deathMsg).getSimpleProvider();
        Bukkit.getOnlinePlayers().forEach(p -> msg.send((CommandSender)p, settings));
        msg.send((CommandSender)Bukkit.getConsoleSender(), settings);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMineStep(PlayerInteractEvent event) {
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!block.getType().name().endsWith("_PLATE")) {
            return;
        }
        Player player = event.getPlayer();
        if (player.isInvulnerable() || PlayerUtils.invulnerableGameMode(player)) {
            return;
        }
        Land land = Land.getLand(block);
        if (land == null) {
            return;
        }
        Turret turret = land.getTurrets().get(SimpleLocation.of(block));
        if (turret == null) {
            return;
        }
        MineTurret mine = (MineTurret)turret;
        if (mine.getLastActivation() != null && mine.getLastActivation().getTime() > Duration.ofMillis(System.currentTimeMillis()).minusSeconds(10L).toMillis()) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = land.getKingdom();
        if (StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(kp.getKingdom(), kingdom)) {
            return;
        }
        TurretActivateEvent activateEvent = new TurretActivateEvent((LivingEntity)player, mine, kingdom, land, block.getLocation(), null);
        Bukkit.getPluginManager().callEvent((Event)activateEvent);
        mine.setLastActivation(activateEvent);
        if (activateEvent.isCancelled()) {
            return;
        }
        mine.beepBeep(new XSound.Record(XSound.BLOCK_NOTE_BLOCK_CHIME, null, block.getLocation(), 5.0f, 2.0f, true), () -> {
            DAMAGED.put((Object)player.getEntityId(), (Object)activateEvent);
            ((TurretType)((TurretStyle)mine.getStyle()).getType()).activate(activateEvent);
            mine.playSound("activate");
            mine.setDurability(mine.getDurability() - 1);
            KingdomItemRemoveContext ctx = new KingdomItemRemoveContext();
            ctx.setDropsItem(false);
            ctx.setCause(activateEvent);
            if (mine.getDurability() <= 0) {
                mine.remove(ctx);
            }
        });
    }

    static {
        disabled = false;
        UPDATE_TICKS = KingdomsConfig.Turrets.UPDATE_TICKS.getManager().getLong();
        if (UPDATE_TICKS < 0L) {
            throw new IllegalArgumentException("Invalid turret update ticks: " + UPDATE_TICKS);
        }
        new TurretTask().runTaskTimer((Plugin)Kingdoms.get(), 600L, UPDATE_TICKS);
    }
}

