/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.turrets;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.KingdomItemPlaceEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.land.LandProtectionManager;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.nbt.NBTTagCompound;
import org.kingdoms.utils.versionsupport.VersionSupport;

public class TurretManager
implements Listener {
    public static void onTurretPlace(PlayerInteractEvent event, NBTTagCompound compound, String tag) {
        event.setCancelled(true);
        Block block = event.getClickedBlock().getRelative(event.getBlockFace());
        if (!XBlock.isAir(block.getType())) {
            KingdomsLang.TURRETS_BLOCK_OCCUPIED.sendError((CommandSender)event.getPlayer(), "material", KingdomsLang.translateMaterial(XMaterial.matchXMaterial(block.getType())));
            return;
        }
        Land land = Land.getLand(block);
        Turret turret = TurretManager.turretPlace(KingdomItemPlaceEvent.fromInteractEvent(event, block), event.getPlayer(), block, compound, land, tag);
        if (turret == null) {
            return;
        }
        XMaterial material = ((TurretStyle)turret.getStyle()).getBlockMaterial(turret.getLevel());
        VersionSupport.rotate(block, material.parseMaterial(), event.getPlayer());
        ((TurretStyle)turret.getStyle()).setSkin(block, turret.getLevel());
        ItemStack item = event.getItem();
        item.setAmount(item.getAmount() - 1);
        turret.playSound("place");
        turret.displayParticle("place");
    }

    public static Turret turretPlace(BlockPlaceEvent event, Player player, Block block, NBTTagCompound nbt, Land land, String tag) {
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_TURRETS_USE.sendError((CommandSender)player, new Object[0]);
            return null;
        }
        if (land == null || !land.isClaimed()) {
            KingdomsLang.UNCLAIMED_PLACE_TURRETS.sendError((CommandSender)player, new Object[0]);
            return null;
        }
        Kingdom landKingdom = land.getKingdom();
        if (!KingdomsPluginPermission.TURRETS_BUILD_PLACE.hasPermission((CommandSender)player, true)) {
            int limit;
            boolean notRegulatored = true;
            Structure structure = land.getStructure(struct -> struct instanceof Regulator);
            if (structure != null) {
                Regulator regulator = (Regulator)structure;
                Boolean attr = regulator.hasAttribute((OfflinePlayer)player, Regulator.Attribute.MANAGE_TURRETS);
                boolean bl = notRegulatored = attr == null || attr == false;
            }
            if (notRegulatored) {
                if (!kp.hasPermission(StandardKingdomPermission.TURRETS)) {
                    StandardKingdomPermission.TURRETS.sendDeniedMessage(player);
                    return null;
                }
                if (!StandardRelationAttribute.MANAGE_TURRETS.hasAttribute(kp.getKingdom(), land.getKingdom())) {
                    KingdomsLang.OTHER_KINGDOMS_TURRET_PLACE.sendError((CommandSender)player, new Object[0]);
                    return null;
                }
            }
            if ((limit = TurretManager.getTotalTurretLimitPerLand(landKingdom)) > 0 && land.getTurrets().size() >= limit) {
                KingdomsLang.TURRETS_LIMIT.sendError((CommandSender)player, "limit", limit);
                return null;
            }
        }
        TurretStyle style = TurretRegistry.getStyle(tag);
        if (!kp.isAdmin()) {
            if (!style.canBePlacedOn(block.getRelative(BlockFace.DOWN))) {
                KingdomsLang.TURRETS_CANT_PLACE.sendError((CommandSender)player, new Object[0]);
                return null;
            }
            if (!style.canBePlacedInBiome(block.getLocation())) {
                KingdomsLang.TURRETS_CANT_PLACE_IN_BIOME.sendError((CommandSender)player, new Object[0]);
                return null;
            }
        }
        SimpleLocation location = SimpleLocation.of(block);
        if (land.getTurrets().containsKey(location)) {
            KingdomsLang.TURRETS_ALREADY_PLACED.sendError((CommandSender)player, new Object[0]);
            return null;
        }
        KingdomItem turret = ((TurretType)style.getType()).build(new KingdomItemBuilder(style, location, kp));
        turret.setDataFromNBT(nbt);
        KingdomItemPlaceEvent<KingdomItem> placeEvent = new KingdomItemPlaceEvent<KingdomItem>(event, kp, land, turret);
        Bukkit.getPluginManager().callEvent(placeEvent);
        if (placeEvent.isCancelled()) {
            return null;
        }
        land.getTurrets().put(location, (Turret)turret);
        turret.spawnHolograms(landKingdom);
        turret.playSound("place");
        turret.displayParticle("place");
        return turret;
    }

    public static int getTotalTurretLimitPerLand(Kingdom kingdom) {
        return (int)MathUtils.eval(KingdomsConfig.Turrets.LIMIT.getManager().getMathExpression(), new PlaceholderContextBuilder().withContext(kingdom).raw("misc_upgrades_max_turrets", MiscUpgrade.MAX_TURRETS.getScaling(kingdom)));
    }

    public static List<Turret> breakExtraTurrets(Kingdom kingdom, Land land) {
        double limit = TurretManager.getTotalTurretLimitPerLand(kingdom);
        if (limit > 0.0 && (double)land.getTurrets().size() >= limit) {
            return new ArrayList<Turret>(land.getTurrets().values());
        }
        return new ArrayList<Turret>();
    }

    public static void onTurretBreak(BlockBreakEvent event, KingdomPlayer kp, Turret turret) {
        Kingdom kingdom;
        Player player = event.getPlayer();
        Land land = turret.getLand();
        if (!kp.isAdmin() && !KingdomsPluginPermission.TURRETS_BUILD_BREAK.hasPermission((CommandSender)player) && land != null && land.isClaimed()) {
            boolean notRegulatored = true;
            Structure structure = land.getStructure(struct -> struct instanceof Regulator);
            if (structure != null) {
                Regulator regulator = (Regulator)structure;
                Boolean attr = regulator.hasAttribute((OfflinePlayer)player, Regulator.Attribute.MANAGE_TURRETS);
                boolean bl = notRegulatored = attr == null || attr == false;
            }
            if (notRegulatored) {
                kingdom = kp.getKingdom();
                if (!StandardRelationAttribute.MANAGE_TURRETS.hasAttribute(kingdom, land.getKingdom())) {
                    KingdomsLang.OTHER_KINGDOMS_TURRET_BREAK.sendError((CommandSender)player, new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                if (kingdom != null && !kp.hasPermission(StandardKingdomPermission.TURRETS)) {
                    StandardKingdomPermission.TURRETS.sendDeniedMessage(player);
                    event.setCancelled(true);
                    return;
                }
            }
        }
        boolean toInv = KingdomsConfig.Turrets.TO_INVENTORY_ON_BREAK.getManager().getBoolean();
        KingdomItemRemoveContext ctx = new KingdomItemRemoveContext();
        ctx.setCause((Event)event);
        ctx.setPlayer(kp);
        ctx.setDropsItem(!toInv);
        if (turret.remove(ctx).isCancelled()) {
            return;
        }
        event.setDropItems(false);
        kingdom = land.getKingdom();
        if (toInv && ((TurretStyle)turret.getStyle()).hasItem()) {
            XItemStack.giveOrDrop(player, turret.getItem(kingdom));
        }
        turret.playSound("break");
        turret.displayParticle("place");
    }

    public static void onTurretInteract(PlayerInteractEvent event, Land land, Turret turret) {
        Player player = event.getPlayer();
        if (player.isSneaking() && KingdomsConfig.Turrets.DISABLE_SHIFT_CLICK.getManager().getBoolean()) {
            Material type = player.getInventory().getItemInMainHand().getType();
            if (type == Material.AIR || !type.isBlock()) {
                event.setUseInteractedBlock(Event.Result.DENY);
            }
            return;
        }
        event.setCancelled(true);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (land.isClaimed() && !KingdomsPluginPermission.TURRETS_INTERACT.hasPermission((CommandSender)player, true)) {
            Kingdom kingdom = kp.getKingdom();
            if (!StandardRelationAttribute.MANAGE_TURRETS.hasAttribute(kingdom, land.getKingdom())) {
                KingdomsLang.OTHER_KINGDOMS_TURRET_INTERACT.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (kingdom != null && !kp.hasPermission(StandardKingdomPermission.TURRETS)) {
                StandardKingdomPermission.TURRETS.sendDeniedMessage(player);
                return;
            }
        }
        KingdomItemInteractEvent<Turret> interactEvent = new KingdomItemInteractEvent<Turret>(event, land, turret);
        Bukkit.getPluginManager().callEvent(interactEvent);
        if (interactEvent.isCancelled()) {
            return;
        }
        if (!land.isClaimed()) {
            KingdomsLang.OTHER_KINGDOMS_TURRET_CAN_TAKE.sendError((CommandSender)player, new Object[0]);
            LandProtectionManager.openKingdomItemGUI(player, turret, interactEvent);
            return;
        }
        ((TurretType)((TurretStyle)turret.getStyle()).getType()).open(new KingdomItemGUIContext<Turret>(interactEvent));
    }
}

