/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services.managers;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.services.ServiceAuth;
import org.kingdoms.services.ServiceDiscordSRV;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.services.pets.ServicePet;
import org.kingdoms.services.vanish.ServiceVanish;
import org.kingdoms.services.worldguard.ServiceWorldGuard;
import org.kingdoms.utils.config.ConfigSection;

public final class ServiceHandler {
    private static final List<BiConsumer<Player, String>> GLOBAL_MESSAGE_HANDLERS = new ArrayList<BiConsumer<Player, String>>();

    public static boolean bankServiceAvailable() {
        return SoftService.VAULT.isAvailable() && ServiceVault.isAvailable(ServiceVault.Component.ECO);
    }

    public static void announce(KingdomsConfig.Chat section, Supplier<MessageBuilder> settings) {
        if (!SoftService.DISCORDSRV.isAvailable()) {
            return;
        }
        String chan = section.getManager().noDefault().withProperty("channel").getString();
        if (Strings.isNullOrEmpty((String)chan)) {
            return;
        }
        TextChannel channel = ServiceDiscordSRV.getChannelWithoutChecks(chan);
        if (channel == null) {
            KLogger.error("Cannot find discord channel '" + chan + '\'');
            return;
        }
        ConfigSection msgSection = section.getManager().noDefault().getSection().getSection();
        ServiceDiscordSRV.sendMessage(channel, msgSection, (MessageBuilder)settings.get());
    }

    public static boolean bankServiceNotAvailable(CommandSender player) {
        if (ServiceHandler.bankServiceAvailable()) {
            return false;
        }
        MessageCompiler.compile("&4Bank services are currently unavailable.\nThis command can only be used with an economy plugin present.\nIf you're the server admin please visit the hover:{&e&nFAQ;Click to open;@https://github.com/CryptoMorin/KingdomsX/wiki/FAQ#bank-services-are-currently-unavailable}&4 on how to setup an economy plugin\n or go to hover:{&e&ncommands.yml;How to disable a command?;@https://github.com/CryptoMorin/KingdomsX/wiki/FAQ#how-to-disable-a-command}&4 config to disable the command.").getExtraProvider().err().send(player, new MessageBuilder().usePrefix());
        return true;
    }

    public static UUID getPetOwner(Entity entity) {
        return Stream.of(SoftService.MC_PETS, SoftService.MY_PET).filter(SoftService::isAvailable).map(x -> ((ServicePet)x.getService()).getOwner(entity)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static Player getPetOwnerPlayer(Entity entity) {
        UUID id = ServiceHandler.getPetOwner(entity);
        return id == null ? null : Bukkit.getPlayer((UUID)id);
    }

    public static boolean isInRegion(SimpleChunkLocation chunk) {
        return ServiceHandler.isInRegion(chunk, 0);
    }

    public static boolean isInRegion(SimpleChunkLocation chunk, int radius) {
        return SoftService.WORLD_GUARD.isAvailable() && ((ServiceWorldGuard)SoftService.WORLD_GUARD.getService()).isChunkInRegion(chunk.getBukkitWorld(), chunk.getX(), chunk.getZ(), radius);
    }

    public static boolean isInRegion(Location location, String region) {
        return SoftService.WORLD_GUARD.isAvailable() && ((ServiceWorldGuard)SoftService.WORLD_GUARD.getService()).isLocationInRegion(location, region);
    }

    public static void addGlobalMessageHandler(BiConsumer<Player, String> handler) {
        GLOBAL_MESSAGE_HANDLERS.add(handler);
    }

    public static boolean isVanished(Player player) {
        for (MetadataValue meta : player.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return Stream.of(SoftService.ESSENTIALS, SoftService.CMI).anyMatch(x -> x.isAvailable() && ((ServiceVanish)x.getService()).isVanished(player));
    }

    public static boolean isInGodMode(Player player) {
        return Stream.of(SoftService.ESSENTIALS, SoftService.CMI).anyMatch(x -> x.isAvailable() && ((ServiceVanish)x.getService()).isInGodMode(player));
    }

    public static void sendGlobalMessage(Player player, String message) {
        for (BiConsumer<Player, String> handler : GLOBAL_MESSAGE_HANDLERS) {
            handler.accept(player, message);
        }
    }

    public static ServiceWorldGuard getWorldGuardService() {
        return (ServiceWorldGuard)SoftService.WORLD_GUARD.getService();
    }

    public static String getGroup(Player player) {
        return SoftService.VAULT.isAvailable() && ServiceVault.isAvailable(ServiceVault.Component.PERM) ? ServiceVault.getGroup(player) : null;
    }

    public static boolean isAuthenticated(Player player) {
        return !SoftService.AUTH_ME.isAvailable() || ((ServiceAuth)SoftService.AUTH_ME.getService()).isAuthenticated(player);
    }

    public static void logPrivateMessage(Player player, String str) {
        if (SoftService.DISCORDSRV.isAvailable()) {
            ServiceDiscordSRV.logPrivateMessages(player, str);
        }
    }
}

