/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services.managers;

import java.util.Arrays;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.kotlin.jvm.functions.Function2;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.services.Service;
import org.kingdoms.services.ServiceProjectKorra;
import org.kingdoms.services.managers.EmptyService;
import org.kingdoms.utils.string.StringUtils;

public enum SoftService {
    CITIZENS("Citizens"),
    MY_PET("MyPet", "org.kingdoms.services.pets.ServiceMyPet"),
    MC_PETS("MCPets", "org.kingdoms.services.pets.ServiceMCPets"),
    MVDWPLACEHOLDERAPI("MVdWPlaceholderAPI", "org.kingdoms.services.placeholders.ServiceMVdWPlaceholder"),
    PLACEHOLDERAPI("PlaceholderAPI", "org.kingdoms.services.placeholders.ServicePlaceholderAPI"),
    PROJECT_KORRA("ProjectKorra", () -> new ServiceProjectKorra((Function2<? super Player, ? super Location, Boolean>)((Function2)(player, location) -> {
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin() || !kp.hasKingdom()) {
            return false;
        }
        SimpleLocation loc = SimpleLocation.of(location);
        Land land = Land.getLand(location);
        if (land == null || land.isClaimed()) {
            return false;
        }
        if (land.getTurrets().containsKey(loc) || land.getStructures().containsKey(loc)) {
            return false;
        }
        Kingdom kingdom = land.getKingdom();
        if (!ServiceProjectKorra.protectDuringInvasions() && !land.getInvasions().isEmpty() && land.getInvasions().values().stream().anyMatch(i -> i.getInvader().equals(kp)) || land.getStructure(Regulator.class) != null && land.getStructure(Regulator.class).hasAttribute((OfflinePlayer)player, Regulator.Attribute.BUILD).booleanValue()) {
            return false;
        }
        if (kingdom.isMember(kp) && !kp.hasPermission(StandardKingdomPermission.BUILD) || !kp.getKingdom().hasAttribute(kingdom, (RelationAttribute)StandardRelationAttribute.BUILD)) {
            return true;
        }
        return true;
    }))),
    WORLD_GUARD("WorldGuard", "org.kingdoms.services.worldguard.ServiceWorldGuardSeven", "org.kingdoms.services.worldguard.ServiceWorldGuardSix"),
    WORLD_EDIT("WorldEdit", "org.kingdoms.services.ServiceWorldEdit"),
    VAULT("Vault", "org.kingdoms.services.ServiceVault"),
    AUTH_ME("AuthMe", "org.kingdoms.services.ServiceAuthMe"),
    DISCORDSRV("DiscordSRV", "org.kingdoms.services.ServiceDiscordSRV"),
    LUCKPERMS("LuckPerms", "org.kingdoms.services.ServiceLuckPerms"),
    MYTHIC_MOBS("MythicMobs", "org.kingdoms.services.mythicmobs.ServiceMythicMobFive", "org.kingdoms.services.mythicmobs.ServiceMythicMobFour"),
    ESSENTIALS("Essentials", "org.kingdoms.services.vanish.ServiceEssentialsX"),
    CMI("CMI", "org.kingdoms.services.vanish.ServiceCMI"),
    SLIMEFUN("Slimefun", "org.kingdoms.services.ServiceSlimefun"),
    DYNMAP("dynmap"),
    BLUEMAP("BlueMap"),
    SQUAREMAP("squaremap"),
    PL3XMAP("Pl3xMap");

    private final String name;
    private final Service service;
    private boolean available;

    private SoftService(String name) {
        this(name, () -> EmptyService.INSTANCE);
    }

    private SoftService(String name, String ... classes) {
        this.name = name;
        this.available = this.checkAvailability();
        this.service = this.available ? SoftService.getCompatibleServiceOf(classes) : null;
        this.available = this.service != null && this.service.isAvailable();
    }

    static Service getCompatibleServiceOf(String ... classes) {
        for (String service : classes) {
            try {
                Service instance = (Service)Class.forName(service).getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!instance.isAvailable()) continue;
                return instance;
            }
            catch (Throwable ex) {
                if (!KLogger.isDebugging()) continue;
                KLogger.error("Error while initializing service with class '" + service + "':");
                ex.printStackTrace();
            }
        }
        return null;
    }

    private SoftService(String name, Supplier<Service> service) {
        this.name = name;
        this.available = this.checkAvailability();
        if (!this.available) {
            this.service = EmptyService.INSTANCE;
            return;
        }
        this.service = service.get();
        this.available = this.service.isAvailable();
    }

    public Service getService() {
        return this.service;
    }

    public String getName() {
        return this.name;
    }

    public static void reportAvailability() {
        for (SoftService service : SoftService.values()) {
            if (service.available) {
                MessageHandler.sendConsolePluginMessage("&6" + service.name + " &2found and hooked.");
                continue;
            }
            MessageHandler.sendConsolePluginMessage("&e" + service.name + " &cnot found.");
        }
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public static boolean anyAvailable(SoftService ... services) {
        return Arrays.stream(services).anyMatch(SoftService::isAvailable);
    }

    public Plugin getPlugin() {
        return Bukkit.getPluginManager().getPlugin(this.name);
    }

    public boolean isAvailable() {
        return this.available;
    }

    private boolean checkAvailability() {
        if (!KingdomsConfig.INTEGRATIONS.getManager().withProperty(StringUtils.configOption(this)).getBoolean()) {
            return false;
        }
        Plugin plugin = Bukkit.getPluginManager().getPlugin(this.name);
        return plugin != null && plugin.isEnabled();
    }
}

