/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services.placeholders;

import java.util.Objects;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Relational;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.compiler.placeholders.Placeholder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderParser;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.services.Service;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;

public final class ServicePlaceholderAPI
extends PlaceholderExpansion
implements Relational,
Service {
    public boolean canRegister() {
        return true;
    }

    public boolean persist() {
        return true;
    }

    public @NonNull String getIdentifier() {
        return "kingdoms";
    }

    public @NonNull String getAuthor() {
        return "Crypto Morin";
    }

    public @NonNull String getVersion() {
        return "10.0.0";
    }

    public String onRequest(OfflinePlayer player, @NonNull String identifier) {
        return ServicePlaceholderAPI.request(player, identifier);
    }

    private static String request(OfflinePlayer player, String identifier) {
        return ServicePlaceholderAPI.requestInternal(player, null, identifier);
    }

    private static String requestInternal(OfflinePlayer player, Player other, String identifier) {
        Placeholder ph = PlaceholderParser.parsePlaceholder(identifier);
        if (ph == null) {
            KLogger.debug((DebugNS)KingdomsDebug.UNKNOWN$PLACEHOLDER, () -> "Requested null placeholder: " + identifier);
            return null;
        }
        MessageBuilder settings = new MessageBuilder().withContext(player).other(other);
        Object translated = ph.request(settings);
        if (translated instanceof MessageObjectBuilder) {
            translated = ((MessageObjectBuilder)translated).buildPlain(settings);
        } else if (translated instanceof Messenger) {
            translated = ((Messenger)translated).parse(settings);
        }
        return Objects.toString(translated);
    }

    @Override
    public void enable() {
        this.register();
    }

    public String onPlaceholderRequest(Player player, Player other, String identifier) {
        return ServicePlaceholderAPI.requestInternal((OfflinePlayer)player, other, identifier);
    }
}

