/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.string.StringUtils;

public final class ConfigCommand {
    private final ExecutorType executorType;
    private final MessageObject command;
    private static final MessageCompilerSettings COMPILER_SETTINGS = new MessageCompilerSettings().colorize().translatePlaceholders();

    public ConfigCommand(ExecutorType executorType, MessageObject command) {
        this.executorType = executorType;
        this.command = command;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<ConfigCommand> parse(Collection<String> commands) {
        if (commands == null) {
            return Collections.emptyList();
        }
        ArrayList<ConfigCommand> list2 = new ArrayList<ConfigCommand>(commands.size());
        for (String command : commands) {
            ExecutorType executorType;
            int index = command.indexOf(58);
            if (index != -1) {
                String option = StringUtils.toLatinUpperCase(command.substring(0, index));
                command = command.substring(index + 1);
                if (option.equals("CONSOLE")) {
                    executorType = ExecutorType.CONSOLE;
                } else {
                    if (!option.equals("OP")) throw new IllegalArgumentException("Unknown command executor '" + option + "' in command: " + command);
                    executorType = ExecutorType.OP;
                }
            } else {
                executorType = ExecutorType.NORMAL;
            }
            if (command.charAt(0) == '/') {
                command = command.substring(1);
            }
            list2.add(new ConfigCommand(executorType, MessageCompiler.compile(command, COMPILER_SETTINGS)));
        }
        return list2;
    }

    public static void execute(@Nullable Player player, Collection<ConfigCommand> commands, MessageBuilder settings, boolean ignoreIfPlayerNull) {
        Consumer<ConfigCommand> checkPlayer = cmd -> Objects.requireNonNull(player, () -> "An online player must be present to execute the command '" + cmd.command.buildPlain(settings) + "' of type " + (Object)((Object)cmd.executorType));
        block5: for (ConfigCommand command : commands) {
            String parsedCmd = command.command.buildPlain(settings);
            switch (command.executorType) {
                case OP: {
                    if (ignoreIfPlayerNull) continue block5;
                    checkPlayer.accept(command);
                    player.setOp(true);
                    Bukkit.dispatchCommand((CommandSender)player, (String)parsedCmd);
                    player.setOp(false);
                    continue block5;
                }
                case CONSOLE: {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsedCmd);
                    continue block5;
                }
                case NORMAL: {
                    if (ignoreIfPlayerNull) continue block5;
                    checkPlayer.accept(command);
                    Bukkit.dispatchCommand((CommandSender)player, (String)parsedCmd);
                    continue block5;
                }
            }
            throw new AssertionError();
        }
    }

    public static enum ExecutorType {
        OP,
        CONSOLE,
        NORMAL;

    }
}

