/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.awt.Color;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.MessagePiece;
import org.kingdoms.utils.ColorUtils;

public final class SingularColorFormat {
    public Color color;
    public boolean bold;
    public boolean italic;
    public boolean underlined;
    public boolean strikethrough;
    public boolean obfuscated;

    public SingularColorFormat from(String str) {
        MessageObject obj = MessageCompiler.compile(str, new MessageCompilerSettings(false, true, true, false, false, null));
        for (MessagePiece piece : obj.getPieces()) {
            if (!(piece instanceof MessagePiece.Color)) continue;
            if (piece instanceof MessagePiece.SimpleColor) {
                MessagePiece.SimpleColor simpColor = (MessagePiece.SimpleColor)piece;
                switch (simpColor.getColor()) {
                    case BOLD: {
                        this.bold = true;
                        break;
                    }
                    case ITALIC: {
                        this.italic = true;
                        break;
                    }
                    case UNDERLINE: {
                        this.underlined = true;
                        break;
                    }
                    case STRIKETHROUGH: {
                        this.strikethrough = true;
                        break;
                    }
                    case MAGIC: {
                        this.obfuscated = true;
                        break;
                    }
                    default: {
                        this.color = ColorUtils.legacyColorToAwt(simpColor.getColor());
                        break;
                    }
                }
                continue;
            }
            if (!(piece instanceof MessagePiece.HexColor)) continue;
            MessagePiece.HexColor hex = (MessagePiece.HexColor)piece;
            this.color = hex.getColor();
        }
        return this;
    }
}

