/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.bossbars;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Player;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.bossbars.BossBarSettings;
import org.kingdoms.utils.cache.EnumCache;
import org.kingdoms.utils.string.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u0004\u0018\u00010\bJ\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\b\u0010\u000f\u001a\u0004\u0018\u00010\bJ\b\u0010\u0010\u001a\u0004\u0018\u00010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/utils/bossbars/BossBarEditor;", "", "player", "Lorg/bukkit/entity/Player;", "bossbar", "Lorg/kingdoms/utils/bossbars/BossBarSettings;", "modifier", "Ljava/util/function/Consumer;", "Lorg/kingdoms/gui/InteractiveGUI;", "(Lorg/bukkit/entity/Player;Lorg/kingdoms/utils/bossbars/BossBarSettings;Ljava/util/function/Consumer;)V", "edits", "", "", "openColorsGUI", "openFlagsGUI", "openGUI", "openStylesGUI", "updateBossBarEdits", "", "core"})
public final class BossBarEditor {
    @NotNull
    private final Player player;
    @NotNull
    private final BossBarSettings bossbar;
    @NotNull
    private final Consumer<InteractiveGUI> modifier;
    @NotNull
    private Map<String, Object> edits;

    public BossBarEditor(@NotNull Player player, @NotNull BossBarSettings bossbar, @NotNull Consumer<InteractiveGUI> modifier) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)bossbar, (String)"bossbar");
        Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
        this.player = player;
        this.bossbar = bossbar;
        this.modifier = modifier;
        this.edits = new HashMap();
    }

    private final void updateBossBarEdits() {
        BarFlag[] barFlagArray = this.edits;
        String string = "bossbar-title";
        String string2 = this.bossbar.getTitle$core().buildPlain(new MessageBuilder());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"bossbar.title.buildPlain(MessageBuilder())");
        String string3 = string2;
        barFlagArray.put((String)string, (Object)string3);
        this.edits.put("bossbar_color", this.bossbar.getColor$core().name());
        this.edits.put("bossbar_style", this.bossbar.getStyle$core().name());
        Intrinsics.checkNotNullExpressionValue((Object)EnumCache.BOSS_BAR_FLAGS, (String)"BOSS_BAR_FLAGS");
        for (BarFlag flag : EnumCache.BOSS_BAR_FLAGS) {
            String string4;
            Map<String, Object> map = this.edits;
            StringBuilder stringBuilder = new StringBuilder().append("bossbar_flag_");
            String string5 = flag.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String string6 = stringBuilder.append(string5).toString();
            Intrinsics.checkNotNullExpressionValue((Object)(ArraysKt.contains((Object[])this.bossbar.getFlags$core(), (Object)flag) ? KingdomsLang.ENABLED.parse(new Object[0]) : KingdomsLang.DISABLED.parse(new Object[0])), (String)"if (bossbar.flags.contai\u2026domsLang.DISABLED.parse()");
            string4 = string4;
            map.put(string6, string4);
        }
    }

    @Nullable
    public final InteractiveGUI openGUI() {
        this.updateBossBarEdits();
        InteractiveGUI interactiveGUI = GUIAccessor.prepare(this.player, KingdomsGUI.BOSSBAR_EDITOR);
        if (interactiveGUI == null) {
            return null;
        }
        InteractiveGUI gui = interactiveGUI;
        gui.getSettings().addAll((Map)this.edits);
        gui.option("title").onNormalClicks(BossBarEditor::openGUI$lambda-0).setConversation((arg_0, arg_1) -> BossBarEditor.openGUI$lambda-1(this, gui, arg_0, arg_1)).done();
        gui.option("colors").onNormalClicks(() -> BossBarEditor.openGUI$lambda-2(this)).done();
        gui.option("styles").onNormalClicks(() -> BossBarEditor.openGUI$lambda-3(this)).done();
        gui.option("flags").onNormalClicks(() -> BossBarEditor.openGUI$lambda-4(this)).done();
        this.modifier.accept(gui);
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    @Nullable
    public final InteractiveGUI openColorsGUI() {
        InteractiveGUI interactiveGUI = GUIAccessor.prepare(this.player, KingdomsGUI.BOSSBAR_COLORS);
        if (interactiveGUI == null) {
            return null;
        }
        InteractiveGUI gui = interactiveGUI;
        Intrinsics.checkNotNullExpressionValue((Object)EnumCache.BOSS_BAR_COLORS, (String)"BOSS_BAR_COLORS");
        for (BarColor color : EnumCache.BOSS_BAR_COLORS) {
            String string = StringUtils.configOption((Enum)color);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(color)");
            gui.option(string).onNormalClicks(arg_0 -> BossBarEditor.openColorsGUI$lambda-5(this, color, arg_0)).done();
        }
        gui.push("back", () -> BossBarEditor.openColorsGUI$lambda-6(this), new Object[0]);
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    @Nullable
    public final InteractiveGUI openStylesGUI() {
        InteractiveGUI interactiveGUI = GUIAccessor.prepare(this.player, KingdomsGUI.BOSSBAR_STYLES);
        if (interactiveGUI == null) {
            return null;
        }
        InteractiveGUI gui = interactiveGUI;
        Intrinsics.checkNotNullExpressionValue((Object)EnumCache.BOSS_BAR_STYLES, (String)"BOSS_BAR_STYLES");
        for (BarStyle style : EnumCache.BOSS_BAR_STYLES) {
            gui.option(style.name()).onNormalClicks(arg_0 -> BossBarEditor.openStylesGUI$lambda-7(this, style, arg_0)).done();
        }
        gui.push("back", () -> BossBarEditor.openStylesGUI$lambda-8(this), new Object[0]);
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    @Nullable
    public final InteractiveGUI openFlagsGUI() {
        InteractiveGUI interactiveGUI = GUIAccessor.prepare(this.player, KingdomsGUI.BOSSBAR_FLAGS);
        if (interactiveGUI == null) {
            return null;
        }
        InteractiveGUI gui = interactiveGUI;
        Set flags = ArraysKt.toMutableSet((Object[])this.bossbar.getFlags$core());
        Intrinsics.checkNotNullExpressionValue((Object)EnumCache.BOSS_BAR_FLAGS, (String)"BOSS_BAR_FLAGS");
        for (BarFlag flag : EnumCache.BOSS_BAR_FLAGS) {
            boolean enabled = flags.contains(flag);
            String string = StringUtils.configOption((Enum)flag);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(flag)");
            Object[] objectArray = new Object[]{"enabled", enabled};
            gui.option(string).setEdits(objectArray).onNormalClicks(arg_0 -> BossBarEditor.openFlagsGUI$lambda-9(enabled, flags, flag, this, arg_0)).done();
        }
        gui.push("back", () -> BossBarEditor.openFlagsGUI$lambda-10(this), new Object[0]);
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    private static final void openGUI$lambda-0(OptionHandler context) {
        context.sendMessage(KingdomsLang.BOSSBAR_EDITOR_TITLE_ENTER, new Object[0]);
        context.startConversation();
    }

    private static final void openGUI$lambda-1(BossBarEditor this$0, InteractiveGUI $gui, OptionHandler optionHandler, String input) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gui, (String)"$gui");
        MessageCompiler compiled = new MessageCompiler(input);
        compiled.compile();
        BossBarSettings bossBarSettings = this$0.bossbar;
        MessageObject messageObject = compiled.compileObject();
        Intrinsics.checkNotNullExpressionValue((Object)messageObject, (String)"compiled.compileObject()");
        bossBarSettings.setTitle$core(messageObject);
        $gui.endConversation();
        this$0.openGUI();
    }

    private static final void openGUI$lambda-2(BossBarEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openColorsGUI();
    }

    private static final void openGUI$lambda-3(BossBarEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openStylesGUI();
    }

    private static final void openGUI$lambda-4(BossBarEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openFlagsGUI();
    }

    private static final void openColorsGUI$lambda-5(BossBarEditor this$0, BarColor $color, OptionHandler optionHandler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BossBarSettings bossBarSettings = this$0.bossbar;
        Intrinsics.checkNotNullExpressionValue((Object)$color, (String)"color");
        bossBarSettings.setColor$core($color);
        this$0.openGUI();
    }

    private static final void openColorsGUI$lambda-6(BossBarEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openGUI();
    }

    private static final void openStylesGUI$lambda-7(BossBarEditor this$0, BarStyle $style, OptionHandler optionHandler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BossBarSettings bossBarSettings = this$0.bossbar;
        Intrinsics.checkNotNullExpressionValue((Object)$style, (String)"style");
        bossBarSettings.setStyle$core($style);
        this$0.openGUI();
    }

    private static final void openStylesGUI$lambda-8(BossBarEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openGUI();
    }

    private static final void openFlagsGUI$lambda-9(boolean $enabled, Set $flags, BarFlag $flag, BossBarEditor this$0, OptionHandler optionHandler) {
        Intrinsics.checkNotNullParameter((Object)$flags, (String)"$flags");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($enabled) {
            $flags.remove($flag);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)$flag, (String)"flag");
            $flags.add($flag);
        }
        BossBarSettings bossBarSettings = this$0.bossbar;
        Collection $this$toTypedArray$iv = $flags;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        BarFlag[] barFlagArray = thisCollection$iv.toArray(new BarFlag[0]);
        Intrinsics.checkNotNull((Object)barFlagArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        bossBarSettings.setFlags$core(barFlagArray);
        this$0.openFlagsGUI();
    }

    private static final void openFlagsGUI$lambda-10(BossBarEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openGUI();
    }
}

