/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache;

import java.util.Map;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.EntityType;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EquipmentSlot;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;

public final class EnumCache {
    public static final EntityType[] ENTITY_TYPES = EntityType.values();
    public static final ClickType[] CLICK_TYPES = ClickType.values();
    public static final BarColor[] BOSS_BAR_COLORS = BarColor.values();
    public static final BarStyle[] BOSS_BAR_STYLES = BarStyle.values();
    public static final BarFlag[] BOSS_BAR_FLAGS = BarFlag.values();
    public static final Attribute[] ATTRIBUTES = Attribute.values();
    public static final EquipmentSlot[] EQUIPMENT_SLOTS = EquipmentSlot.values();
    public static final Map<InventoryType, XMaterial> INVENTORY_TO_MATERIAL_MAPPING = new QuickEnumMap((Enum[])InventoryType.values());

    private EnumCache() {
    }

    static {
        INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.ANVIL, XMaterial.ANVIL);
        INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.DISPENSER, XMaterial.DISPENSER);
        INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.DROPPER, XMaterial.DROPPER);
        INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.FURNACE, XMaterial.FURNACE);
        INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.WORKBENCH, XMaterial.CRAFTING_TABLE);
        INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.ENCHANTING, XMaterial.ENCHANTING_TABLE);
        INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.BREWING, XMaterial.BREWING_STAND);
        INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.ENDER_CHEST, XMaterial.ENDER_CHEST);
        INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.BEACON, XMaterial.BEACON);
        INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.HOPPER, XMaterial.HOPPER);
        INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.SHULKER_BOX, XMaterial.SHULKER_BOX);
        if (XMaterial.supports(14)) {
            INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.SMITHING, XMaterial.SMITHING_TABLE);
            INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.BARREL, XMaterial.BARREL);
            INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.BLAST_FURNACE, XMaterial.BLAST_FURNACE);
            INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.LECTERN, XMaterial.LECTERN);
            INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.SMOKER, XMaterial.SMOKER);
            INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.LOOM, XMaterial.LOOM);
            INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.CARTOGRAPHY, XMaterial.CARTOGRAPHY_TABLE);
            INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.GRINDSTONE, XMaterial.GRINDSTONE);
            INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.STONECUTTER, XMaterial.STONECUTTER);
            if (XMaterial.supports(17)) {
                INVENTORY_TO_MATERIAL_MAPPING.put(InventoryType.COMPOSTER, XMaterial.COMPOSTER);
            }
        }
    }
}

