/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.snakeyaml.api.LoadSettings;
import org.kingdoms.libs.snakeyaml.common.FlowStyle;
import org.kingdoms.libs.snakeyaml.common.ScalarStyle;
import org.kingdoms.libs.snakeyaml.constructor.BaseConstructor;
import org.kingdoms.libs.snakeyaml.constructor.StandardConstructor;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.nodes.NodeType;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.snakeyaml.nodes.SequenceNode;
import org.kingdoms.libs.snakeyaml.nodes.Tag;
import org.kingdoms.libs.snakeyaml.resolver.StandardScalarResolver;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.config.CustomConfigValidators;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.time.TimeUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000 \u0007*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0007J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/utils/config/NodeInterpreter;", "T", "", "parse", "node", "Lorg/kingdoms/libs/snakeyaml/nodes/Node;", "(Lorg/snakeyaml/nodes/Node;)Ljava/lang/Object;", "Companion", "core"})
public interface NodeInterpreter<T> {
    @NotNull
    public static final Companion Companion = org.kingdoms.utils.config.NodeInterpreter$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final BaseConstructor DEFAULT_CTOR = new StandardConstructor(new LoadSettings());
    @JvmField
    @NotNull
    public static final StandardScalarResolver DEFAULT_RESOLVER = new StandardScalarResolver();
    @JvmField
    @NotNull
    public static final NodeInterpreter<String> STRING = NodeInterpreter::STRING$lambda-0;
    @JvmField
    @NotNull
    public static final NodeInterpreter<List<Integer>> INT_LIST = NodeInterpreter::INT_LIST$lambda-1;
    @JvmField
    @NotNull
    public static final NodeInterpreter<List<String>> STRING_LIST = NodeInterpreter::STRING_LIST$lambda-2;
    @JvmField
    @NotNull
    public static final NodeInterpreter<Float> FLOAT = NodeInterpreter::FLOAT$lambda-3;
    @JvmField
    @NotNull
    public static final NodeInterpreter<Long> LONG = NodeInterpreter::LONG$lambda-4;
    @JvmField
    @NotNull
    public static final NodeInterpreter<Double> DOUBLE = NodeInterpreter::DOUBLE$lambda-5;
    @JvmField
    @NotNull
    public static final NodeInterpreter<Boolean> BOOLEAN = NodeInterpreter::BOOLEAN$lambda-6;
    @JvmField
    @NotNull
    public static final NodeInterpreter<Integer> INT = NodeInterpreter::INT$lambda-7;
    @JvmField
    @NotNull
    public static final NodeInterpreter<ConditionalCompiler.LogicalOperand> CONDITION = NodeInterpreter::CONDITION$lambda-8;
    @JvmField
    @NotNull
    public static final NodeInterpreter<MathCompiler.Expression> MATH = NodeInterpreter::MATH$lambda-9;
    @JvmField
    @NotNull
    public static final NodeInterpreter<LanguageEntry> MESSAGE_ENTRY = NodeInterpreter::MESSAGE_ENTRY$lambda-10;

    public T parse(@Nullable Node var1);

    private static String STRING$lambda-0(Node it) {
        if (it == null) {
            return null;
        }
        if (it.getNodeType() != NodeType.SCALAR) {
            return null;
        }
        return it.getParsed() == null ? null : ((ScalarNode)it).getValue();
    }

    private static List INT_LIST$lambda-1(Node it) {
        if (it == null || it.getNodeType() != NodeType.SEQUENCE) {
            return new ArrayList();
        }
        SequenceNode seq = (SequenceNode)it;
        List list2 = new ArrayList(seq.getValue().size());
        for (Node item : seq.getValue()) {
            if (!(item.getParsed() instanceof Number)) continue;
            Object object = item.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            list2.add(((Number)object).intValue());
        }
        return list2;
    }

    private static List STRING_LIST$lambda-2(Node it) {
        if (it == null) {
            return new ArrayList();
        }
        if (it.getNodeType() != NodeType.SEQUENCE) {
            if (it.getNodeType() == NodeType.SCALAR) {
                ScalarNode scalarNode = (ScalarNode)it;
                List<String> list2 = StringUtils.split(scalarNode.getValue(), '\n', true);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"split(scalarNode.value, '\\n', true)");
                return list2;
            }
            return new ArrayList();
        }
        SequenceNode sequenceNode = (SequenceNode)it;
        List strings = new ArrayList(sequenceNode.getValue().size());
        for (Node element : sequenceNode.getValue()) {
            String parsed = STRING.parse(element);
            if (parsed == null) continue;
            strings.add(parsed);
        }
        return strings;
    }

    private static float FLOAT$lambda-3(Node it) {
        float f;
        if (it == null) {
            return 0.0f;
        }
        if (!(it.getParsed() instanceof Number)) {
            f = 0.0f;
        } else {
            Object object = it.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            f = ((Number)object).floatValue();
        }
        return f;
    }

    private static long LONG$lambda-4(Node it) {
        long l;
        if (it == null) {
            return 0L;
        }
        if (!(it.getParsed() instanceof Number)) {
            l = 0L;
        } else {
            Object object = it.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            l = ((Number)object).longValue();
        }
        return l;
    }

    private static double DOUBLE$lambda-5(Node it) {
        double d;
        if (it == null) {
            return 0.0;
        }
        if (!(it.getParsed() instanceof Number)) {
            d = 0.0;
        } else {
            Object object = it.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            d = ((Number)object).doubleValue();
        }
        return d;
    }

    private static boolean BOOLEAN$lambda-6(Node it) {
        boolean bl;
        if (it == null) {
            return false;
        }
        if (!(it.getParsed() instanceof Boolean)) {
            bl = false;
        } else {
            Object object = it.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            bl = (Boolean)object;
        }
        return bl;
    }

    private static int INT$lambda-7(Node it) {
        int n;
        if (it == null) {
            return 0;
        }
        if (!(it.getParsed() instanceof Number)) {
            n = 0;
        } else {
            Object object = it.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            n = ((Number)object).intValue();
        }
        return n;
    }

    private static ConditionalCompiler.LogicalOperand CONDITION$lambda-8(Node it) {
        if (it == null) {
            return null;
        }
        if (it.getNodeType() != NodeType.SCALAR) {
            return null;
        }
        if (!(it.getParsed() instanceof ConditionalCompiler.LogicalOperand)) {
            ScalarNode scalarNode = (ScalarNode)it;
            ((ScalarNode)it).cacheConstructed(ConditionalCompiler.compile(scalarNode.getValue()).evaluate());
        }
        Object object = it.getParsed();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.ConditionalCompiler.LogicalOperand");
        return (ConditionalCompiler.LogicalOperand)object;
    }

    private static MathCompiler.Expression MATH$lambda-9(Node it) {
        if (it == null) {
            return MathCompiler.DEFAULT_VALUE;
        }
        if (it.getNodeType() != NodeType.SCALAR) {
            return MathCompiler.DEFAULT_VALUE;
        }
        if (!(it.getParsed() instanceof MathCompiler.Expression)) {
            ScalarNode scalarNode = (ScalarNode)it;
            ((ScalarNode)it).cacheConstructed(MathCompiler.Companion.compile(scalarNode.getValue()));
        }
        Object object = it.getParsed();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
        return (MathCompiler.Expression)object;
    }

    private static LanguageEntry MESSAGE_ENTRY$lambda-10(Node it) {
        if (it == null) {
            return KingdomsLang.UNKNOWN_MESSAGE_ENTRY.getLanguageEntry();
        }
        if (it.getNodeType() != NodeType.SCALAR) {
            return KingdomsLang.UNKNOWN_MESSAGE_ENTRY.getLanguageEntry();
        }
        if (!(it.getParsed() instanceof LanguageEntry)) {
            ScalarNode scalarNode = (ScalarNode)it;
            ((ScalarNode)it).cacheConstructed(LanguageEntry.fromConfig(scalarNode.getValue()));
        }
        Object object = it.getParsed();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.kingdoms.locale.LanguageEntry");
        return (LanguageEntry)object;
    }

    @JvmStatic
    @Nullable
    public static Long getTime(@Nullable Node node, @Nullable PlaceholderContextProvider ctx) {
        return Companion.getTime(node, ctx);
    }

    @JvmStatic
    @NotNull
    public static Node nodeOfObject(@Nullable Object obj) {
        return Companion.nodeOfObject(obj);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010 \u001a\u0004\u0018\u00010\u00152\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0007\u00a2\u0006\u0002\u0010%J\u0012\u0010&\u001a\u00020\"2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0007R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001b\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001f\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00130\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0019\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001e\u0010\u0018\u001a\r\u0012\t\u0012\u00070\u0019\u00a2\u0006\u0002\b\u001a0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001b\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R;\u0010\u001d\u001a*\u0012&\u0012$\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u001c0\u001c \u001e*\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u001c0\u001c0\u001f0\u00130\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006("}, d2={"Lorg/kingdoms/utils/config/NodeInterpreter$Companion;", "", "()V", "BOOLEAN", "Lorg/kingdoms/utils/config/NodeInterpreter;", "", "CONDITION", "Lorg/kingdoms/utils/compilers/ConditionalCompiler$LogicalOperand;", "DEFAULT_CTOR", "Lorg/kingdoms/libs/snakeyaml/constructor/BaseConstructor;", "DEFAULT_RESOLVER", "Lorg/kingdoms/libs/snakeyaml/resolver/StandardScalarResolver;", "DOUBLE", "", "FLOAT", "", "INT", "", "INT_LIST", "", "LONG", "", "MATH", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "MESSAGE_ENTRY", "Lorg/kingdoms/locale/LanguageEntry;", "Lorg/kingdoms/libs/checkerframework/checker/nullness/qual/NonNull;", "STRING", "", "STRING_LIST", "org.kingdoms.libs.kotlin.jvm.PlatformType", "", "getTime", "node", "Lorg/kingdoms/libs/snakeyaml/nodes/Node;", "ctx", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderContextProvider;", "(Lorg/snakeyaml/nodes/Node;Lorg/kingdoms/locale/compiler/placeholders/PlaceholderContextProvider;)Ljava/lang/Long;", "nodeOfObject", "obj", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Long getTime(@Nullable Node node, @Nullable PlaceholderContextProvider ctx) {
            if (node == null) {
                return null;
            }
            Object cache = null;
            if (node.getTag() != CustomConfigValidators.PERIOD) {
                Object object;
                ScalarNode scalarNode = (ScalarNode)node;
                try {
                    object = MathCompiler.Companion.compile(scalarNode.getValue());
                }
                catch (Throwable ignored) {
                    object = TimeUtils.parseTime(scalarNode.getValue());
                }
                cache = object;
                if (cache == null) {
                    return null;
                }
                ((ScalarNode)node).setTag(CustomConfigValidators.PERIOD);
                ((ScalarNode)node).cacheConstructed(cache);
            } else {
                cache = node.getParsed();
            }
            return cache instanceof Number ? Long.valueOf(((Number)cache).longValue()) : Long.valueOf((long)MathUtils.eval((MathCompiler.Expression)cache, ctx));
        }

        @JvmStatic
        @NotNull
        public final Node nodeOfObject(@Nullable Object obj) {
            if (obj == null) {
                return new ScalarNode(Tag.NULL, "~", ScalarStyle.PLAIN);
            }
            if (obj instanceof Node) {
                return (Node)obj;
            }
            if (obj instanceof Collection) {
                List nodes = new ArrayList(((Collection)obj).size());
                for (Object item : (Collection)obj) {
                    nodes.add(this.nodeOfObject(item));
                }
                return new SequenceNode(Tag.SEQ, nodes, FlowStyle.AUTO);
            }
            if (obj instanceof Map) {
                throw new UnsupportedOperationException("Mapping from objects");
            }
            ScalarNode node = new ScalarNode(DEFAULT_RESOLVER.resolve(obj.toString()), obj.toString(), ScalarStyle.AUTO);
            node.cacheConstructed(DEFAULT_CTOR.constructObject(node));
            return node;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

