/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cooldown;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.cooldown.CooldownContainer;

public final class EntityCooldown {
    public static boolean add(Entity entity, String name, long time) {
        return EntityCooldown.add(entity, name, time, TimeUnit.SECONDS);
    }

    public static boolean add(Entity entity, String name, long time, TimeUnit timeUnit) {
        if (EntityCooldown.isInCooldown(entity, name)) {
            return false;
        }
        entity.setMetadata(name, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)new CooldownContainer(timeUnit.toMillis(time), System.currentTimeMillis())));
        return true;
    }

    public static boolean isInCooldown(Entity entity, String name) {
        return EntityCooldown.getTimeLeft(entity, name) != 0L;
    }

    public static void stop(Entity entity, String name) {
        entity.removeMetadata(name, (Plugin)Kingdoms.get());
    }

    public static CooldownContainer get(Entity entity, String name) {
        List meta = entity.getMetadata(name);
        if (meta.isEmpty()) {
            return null;
        }
        return (CooldownContainer)((MetadataValue)meta.get(0)).value();
    }

    public static long getTimeLeft(Entity entity, String name) {
        CooldownContainer cooldown = EntityCooldown.get(entity, name);
        if (cooldown == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long difference = now - cooldown.start;
        if (difference >= cooldown.time) {
            EntityCooldown.stop(entity, name);
            return 0L;
        }
        return cooldown.time - difference;
    }
}

