/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.enumeration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;

public class QuickEnumMap<K extends Enum<K>, V>
implements Map<K, V> {
    private final transient V[] vals;
    private transient int size = 0;
    private final transient K[] universe;

    public QuickEnumMap(K[] universe) {
        this.universe = universe;
        this.vals = new Object[universe.length];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        for (V val : this.vals) {
            if (!value.equals(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V get(Object key) {
        Objects.requireNonNull(key, "QuickEnumMap may not contain null keys");
        return this.vals[((Enum)key).ordinal()];
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(key, "QuickEnumMap may not contain null keys");
        Objects.requireNonNull(value, "QuickEnumMap may not contain null values");
        int index = ((Enum)key).ordinal();
        V oldValue = this.vals[index];
        this.vals[index] = value;
        if (oldValue == null) {
            ++this.size;
        }
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        Objects.requireNonNull(key, "QuickEnumMap may not contain null keys");
        int index = ((Enum)key).ordinal();
        V oldValue = this.vals[index];
        this.vals[index] = null;
        if (oldValue != null) {
            --this.size;
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        Arrays.fill(this.vals, null);
        this.size = 0;
    }

    @Override
    public @NonNull Set<K> keySet() {
        QuickEnumSet keys = new QuickEnumSet(this.universe);
        for (int i = 0; i < this.vals.length; ++i) {
            if (this.vals[i] == null) continue;
            keys.add(this.universe[i]);
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public @NonNull Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>(this.size);
        for (V val : this.vals) {
            if (val == null) continue;
            values.add(val);
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public @NonNull Set<Map.Entry<K, V>> entrySet() {
        HashSet<Pair<K, V>> entries = new HashSet<Pair<K, V>>(this.size);
        for (int i = 0; i < this.vals.length; ++i) {
            V val = this.vals[i];
            if (val == null) continue;
            entries.add(Pair.of(this.universe[i], val));
        }
        return Collections.unmodifiableSet(entries);
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Cannot check equality between QuickEnumMap");
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException("Cannot genereate hashcode for QuickEnumMap");
    }
}

