/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.nbt;

import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.nbt.NBTTagCompound;
import org.kingdoms.utils.nbt.NBTType;

public class PersistentNBTTagCompound
implements NBTTagCompound {
    private final PersistentDataContainer container;

    public PersistentNBTTagCompound(PersistentDataContainer container) {
        this.container = container;
    }

    public PersistentNBTTagCompound(ItemMeta meta) {
        this.container = meta.getPersistentDataContainer().getAdapterContext().newPersistentDataContainer();
    }

    @Override
    public <T> void set(String key, NBTType<T> type, T value) {
        this.container.set(new NamespacedKey((Plugin)Kingdoms.get(), key), type.getPersistentDataType(), value);
    }

    @Override
    public <T> T get(String key, NBTType<T> type) {
        return (T)this.container.get(new NamespacedKey((Plugin)Kingdoms.get(), key), type.getPersistentDataType());
    }

    @Override
    public <T> boolean has(String key, NBTType<T> type) {
        return this.container.has(new NamespacedKey((Plugin)Kingdoms.get(), key), type.getPersistentDataType());
    }

    @Override
    public Object getContainer() {
        return this.container;
    }
}

