/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.scoreboards;

import com.google.common.collect.MapMaker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.scoreboards.XScoreboard;

public final class Glow
implements Listener {
    private static final Map<Integer, Entity> ENTITY_ID_MAPPING;
    private static final Map<UUID, Set<Entity>> GLOWS;
    private static final Map<UUID, Set<Player>> GLOWING_FOR;
    private static final boolean isPaper;
    static Class<?> DataWatcher;
    static Class<?> DataWatcherItem;
    private static final Class<?> DATA_WATCHER_ITEMS_TYPE;
    private static final Class<?> PacketPlayOutEntityMetadata;
    private static final Class<?> Entity;

    public static void setGlowing(Player receiver, XScoreboard.Color color, Entity ... members) {
        Objects.requireNonNull(members);
        Objects.requireNonNull(receiver);
        Set glows = GLOWS.computeIfAbsent(receiver.getUniqueId(), k -> new HashSet());
        glows.addAll(Arrays.asList(members));
        Set glowFor = GLOWING_FOR.computeIfAbsent(receiver.getUniqueId(), k -> new HashSet());
        glowFor.add(receiver);
        for (Entity entity : members) {
            Glow.sendGlowPacket(receiver, true, entity);
        }
        new XScoreboard().setColor(color).setMembers(Arrays.asList(members)).build().setScoreboard(receiver);
    }

    public static void removeGlow(Player receiver) {
        Objects.requireNonNull(receiver);
        Set<Entity> entities = GLOWS.remove(receiver.getUniqueId());
        for (Entity entity : entities) {
            Glow.sendGlowPacket(receiver, false, entity);
        }
    }

    public static boolean isGlowing(Entity entity, Player receiver) {
        Set<Player> glows = GLOWING_FOR.get(entity.getUniqueId());
        return glows != null && glows.contains(receiver);
    }

    private static byte magicGlowIndex(boolean glowing, byte flags) {
        return (byte)(glowing ? flags | 0x40 : flags & 0xFFFFFFBF);
    }

    protected static void sendGlowPacket(Player receiver, boolean glowing, Entity entity) {
        try {
            Object packetMetadata;
            ENTITY_ID_MAPPING.put(entity.getEntityId(), entity);
            Method handle = entity.getClass().getDeclaredMethod("getHandle", new Class[0]);
            Object dataWatcher = Entity.getDeclaredMethod("getDataWatcher", new Class[0]).invoke(handle.invoke((Object)entity, new Object[0]), new Object[0]);
            Map dataWatcherItems = (Map)Glow.resolveByLastType(DataWatcher, DATA_WATCHER_ITEMS_TYPE).get(dataWatcher);
            Field field = null;
            for (Field fieldloop : Entity.getDeclaredFields()) {
                if (!"DataWatcherObject".equals(fieldloop.getType().getSimpleName())) continue;
                field = fieldloop;
                break;
            }
            field.setAccessible(true);
            Object dataWatcherObject = field.get(null);
            field = DataWatcherItem.getDeclaredField("b");
            field.setAccessible(true);
            byte flags = (Byte)(dataWatcherItems.isEmpty() ? Integer.valueOf(0) : field.get(dataWatcherItems.get(0)));
            byte newFlags = Glow.magicGlowIndex(glowing, flags);
            Object dataWatcherItem = DataWatcherItem.getConstructors()[0].newInstance(dataWatcherObject, newFlags);
            if (ReflectionUtils.supports(17)) {
                packetMetadata = PacketPlayOutEntityMetadata.getConstructor(Integer.TYPE, DataWatcher, Boolean.TYPE).newInstance(-entity.getEntityId(), dataWatcher, true);
                field = PacketPlayOutEntityMetadata.getDeclaredField("b");
                field.setAccessible(true);
                List dataWatcherList = (List)field.get(packetMetadata);
                dataWatcherList.clear();
                dataWatcherList.add(dataWatcherItem);
            } else {
                packetMetadata = PacketPlayOutEntityMetadata.newInstance();
                field = PacketPlayOutEntityMetadata.getDeclaredField("a");
                field.setAccessible(true);
                field.set(packetMetadata, -entity.getEntityId());
                ArrayList list2 = new ArrayList(8);
                list2.add(dataWatcherItem);
                field = PacketPlayOutEntityMetadata.getDeclaredField("b");
                field.setAccessible(true);
                field.set(packetMetadata, list2);
            }
            ReflectionUtils.sendPacketSync(receiver, packetMetadata);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field resolveByLastType(Class<?> clazz, Class<?> type) throws ReflectiveOperationException {
        Field field = null;
        for (Field field1 : clazz.getDeclaredFields()) {
            if (field1.getType() != type) continue;
            field = field1;
        }
        if (field == null) {
            throw new NoSuchFieldException("Could not resolve field of type '" + type.toString() + "' in class " + clazz);
        }
        field.setAccessible(true);
        return field;
    }

    static {
        boolean paper;
        ENTITY_ID_MAPPING = new MapMaker().weakValues().makeMap();
        GLOWS = new HashMap<UUID, Set<Entity>>();
        GLOWING_FOR = new HashMap<UUID, Set<Player>>();
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            paper = true;
        }
        catch (Exception ignored) {
            paper = false;
        }
        isPaper = paper;
        PacketPlayOutEntityMetadata = ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutEntityMetadata");
        DataWatcher = ReflectionUtils.getNMSClass("network.syncher", "DataWatcher");
        DataWatcherItem = ReflectionUtils.getNMSClass("network.syncher", "DataWatcher$Item");
        Entity = ReflectionUtils.getNMSClass("world.entity", "Entity");
        Class dataWatcherItemsType = null;
        try {
            dataWatcherItemsType = !ReflectionUtils.supports(14) ? Map.class : (!ReflectionUtils.supports(17) ? (isPaper ? Class.forName("it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap") : Class.forName("org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap")) : (isPaper ? Class.forName("it.unimi.dsi.fastutil.ints.Int2ObjectMap") : Class.forName("org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.ints.Int2ObjectMap")));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        DATA_WATCHER_ITEMS_TYPE = dataWatcherItemsType;
        KLogger.error("Protocol channels opened unexpectedly");
        throw new IllegalStateException();
    }
}

