/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.string;

import java.util.Objects;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;

public class QuantumString
implements Cloneable {
    private final @Nullable String original;
    private final @NonNull String quantumValue;

    public QuantumString(@NonNull String original, boolean quantum) {
        Objects.requireNonNull(original, "Quantum original string cannot be null");
        this.original = quantum ? original : null;
        this.quantumValue = quantum ? original.toLowerCase() : original;
    }

    public QuantumString(@Nullable String value, @NonNull String quantumValue) {
        this.original = value;
        this.quantumValue = Objects.requireNonNull(quantumValue, "Quantum value of string cannot be null");
    }

    public int length() {
        return this.quantumValue.length();
    }

    public boolean isEmpty() {
        return this.quantumValue.isEmpty();
    }

    public static QuantumString empty() {
        return new QuantumString("", false);
    }

    public boolean isQuantum() {
        return this.original != null;
    }

    public int hashCode() {
        return this.quantumValue.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof QuantumString && this.quantumValue.equals(((QuantumString)obj).quantumValue);
    }

    public String toString() {
        return "QuantumString:[quantum= " + this.isQuantum() + ", original=" + this.original + ", quantumValue=" + this.quantumValue + ']';
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public @Nullable String getOriginal() {
        return this.original;
    }

    public @NonNull String getQuantumValue() {
        return this.quantumValue;
    }

    public @NonNull String getQuantum() {
        return this.isQuantum() ? this.original : this.quantumValue;
    }
}

