/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.string.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.string.tree.EntryPrinter;
import org.kingdoms.utils.string.tree.PrinterContext;
import org.kingdoms.utils.string.tree.StringTree;
import org.kingdoms.utils.string.tree.StringTreeKt;
import org.kingdoms.utils.string.tree.TreeColorScheme;
import org.kingdoms.utils.string.tree.TreeTokenType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/utils/string/tree/ContainerPrinter;", "Lorg/kingdoms/utils/string/tree/EntryPrinter;", "name", "", "(Ljava/lang/String;)V", "children", "", "getChildren$core", "()Ljava/util/List;", "getName$core", "()Ljava/lang/String;", "setName$core", "print", "", "context", "Lorg/kingdoms/utils/string/tree/PrinterContext;", "printChildren", "", "toString", "Companion", "core"})
public class ContainerPrinter
implements EntryPrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @NotNull
    private final List<EntryPrinter> children;
    @NotNull
    public static final String ROOT = "";

    public ContainerPrinter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.children = new ArrayList();
    }

    @NotNull
    public final String getName$core() {
        return this.name;
    }

    public final void setName$core(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final List<EntryPrinter> getChildren$core() {
        return this.children;
    }

    @Override
    public void print(@NotNull PrinterContext context) {
        boolean columize;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        StringTree tree = context.getTree();
        int nestLevel = context.getNestLevel();
        if (!Intrinsics.areEqual((Object)this.name, (Object)ROOT)) {
            tree.writeEntry(nestLevel, this.name);
            if (nestLevel > tree.getStyle$core().getMaxNestLevel()) {
                tree.getCurrentBuilder().append(tree.getStyle$core().getEllipsis());
                return;
            }
            tree.newLine();
        }
        boolean bl = columize = tree.getStyle$core().getColumizeFromLevel() <= nestLevel;
        if (!columize) {
            this.printChildren(this.children, context);
            return;
        }
        List leftChildren = this.children;
        int maxRows = tree.getStyle$core().calculatedMaxRows();
        int maxColumns = tree.getStyle$core().getMaxColumns();
        int rows = maxRows == Integer.MAX_VALUE ? (int)Math.ceil((double)this.children.size() / (double)maxColumns) : maxRows;
        int currentLinePos = tree.getLinePosition();
        int i = 0;
        if (i <= maxColumns) {
            while (true) {
                List children = CollectionsKt.take((Iterable)leftChildren, (int)rows);
                leftChildren = CollectionsKt.drop((Iterable)leftChildren, (int)rows);
                this.printChildren(children, context);
                if (this.maxEntriesExceeded(context)) {
                    return;
                }
                if (leftChildren.isEmpty()) break;
                tree.revertLinePosition(currentLinePos);
                Iterable iterable = CollectionsKt.drop((Iterable)tree.getLines(), (int)tree.getLinePosition());
                PrinterContext printerContext = context;
                Iterator iterator = iterable.iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                StringBuilder x = (StringBuilder)iterator.next();
                boolean bl2 = false;
                Function<String, Integer> function = tree.getStyle$core().getColumnSpaceModifier();
                if (function == null || (function = function.apply(x.toString())) == null) {
                    function = x.length();
                }
                Intrinsics.checkNotNullExpressionValue((Object)function, (String)"tree.style.columnSpaceMo\u2026x.toString()) ?: x.length");
                int n = ((Number)((Object)function)).intValue();
                while (iterator.hasNext()) {
                    StringBuilder x2 = (StringBuilder)iterator.next();
                    $i$a$-maxOf-ContainerPrinter$print$1 = false;
                    Function<String, Integer> function2 = tree.getStyle$core().getColumnSpaceModifier();
                    if (function2 == null || (function2 = function2.apply(x2.toString())) == null) {
                        function2 = x2.length();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)function2, (String)"tree.style.columnSpaceMo\u2026x.toString()) ?: x.length");
                    int n2 = ((Number)((Object)function2)).intValue();
                    if (n >= n2) continue;
                    n = n2;
                }
                int n3 = n;
                printerContext.setCurrentColumnLongestEntry(n3);
                if (i == maxColumns) break;
                ++i;
            }
        }
        tree.setLinePosition(tree.getLines().size() - 1);
        tree.setCurrentBuilder((StringBuilder)CollectionsKt.last((List)tree.getLines()));
    }

    private final void printChildren(List<? extends EntryPrinter> children, PrinterContext context) {
        StringTree tree = context.getTree();
        int nestLevel = context.getNestLevel();
        String nest = StringTreeKt.getOrEmpty(tree.getStyle$core().getCharacters(), TreeTokenType.INDICATOR_VERTICAL_LINE) + StringsKt.repeat((CharSequence)" ", (int)tree.getStyle$core().getIndentation());
        String nestColor = StringTreeKt.getOrEmpty(tree.getStyle$core().getColors(), TreeColorScheme.INDICATORS);
        Iterator<? extends EntryPrinter> iterator = children.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TreeTokenType token;
            int index = n++;
            EntryPrinter child = iterator.next();
            TreeTokenType treeTokenType = index == 0 ? TreeTokenType.INDICATOR_CORNERS_FIRST : (token = index + 1 < children.size() ? TreeTokenType.INDICATOR_MIDDLE : TreeTokenType.INDICATOR_CORNERS_LAST);
            if (tree.getStyle$core().getIndentFirstLevel() || nestLevel > 0) {
                int spaces = tree.getStyle$core().getIndentFirstLevel() ? nestLevel : nestLevel - 1;
                boolean writeIndicator = false;
                if (context.getCurrentColumnLongestEntry() <= 0) {
                    tree.getCurrentBuilder().append(nestColor).append(StringsKt.repeat((CharSequence)nest, (int)spaces));
                    writeIndicator = true;
                } else {
                    StringBuilder stringBuilder;
                    String currBuilder;
                    writeIndicator = false;
                    Intrinsics.checkNotNullExpressionValue((Object)tree.getCurrentBuilder().toString(), (String)"tree.currentBuilder.toString()");
                    Function<String, Integer> function = tree.getStyle$core().getColumnSpaceModifier();
                    if (function == null || (function = function.apply(currBuilder)) == null) {
                        function = currBuilder.length();
                    }
                    int rawBuilderLength = ((Number)((Object)function)).intValue();
                    int netPadding = RangesKt.coerceAtLeast((int)0, (int)(context.getCurrentColumnLongestEntry() - rawBuilderLength));
                    StringBuilder $this$printChildren_u24lambda_u2d1 = stringBuilder = tree.getCurrentBuilder();
                    boolean bl = false;
                    $this$printChildren_u24lambda_u2d1.setLength(0);
                    $this$printChildren_u24lambda_u2d1.append(currBuilder);
                    $this$printChildren_u24lambda_u2d1.append(StringsKt.repeat((CharSequence)" ", (int)netPadding));
                    $this$printChildren_u24lambda_u2d1.append(context.getTree().getStyle$core().getColumnIdentation());
                }
                tree.writeIndicator(writeIndicator, token);
            }
            child.print(new PrinterContext(nestLevel + 1, tree, context.getColumn(), context.getCurrentColumnLongestEntry()));
            if (this.maxEntriesExceeded(context)) {
                return;
            }
            if (index + 1 >= children.size()) continue;
            tree.newLine();
        }
    }

    @Override
    @NotNull
    public String toString() {
        return this.name;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/kingdoms/utils/string/tree/ContainerPrinter$Companion;", "", "()V", "ROOT", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

