/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.string.tree;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.string.tree.ContainerPrinter;
import org.kingdoms.utils.string.tree.EntryPrinter;
import org.kingdoms.utils.string.tree.StringPrinter;
import org.kingdoms.utils.string.tree.StringTree;
import org.kingdoms.utils.string.tree.TreeStyle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00042\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0007j\u0002`\bH\u0002J.\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0007j\u0002`\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/utils/string/tree/StringPathBuilder;", "", "strings", "", "", "(Ljava/util/List;)V", "tree", "Ljava/util/LinkedHashMap;", "Lorg/kingdoms/utils/string/tree/Folder;", "build", "Lorg/kingdoms/utils/string/tree/ContainerPrinter;", "getEntryOf", "name", "folder", "put", "", "list", "Ljava/util/LinkedList;", "toStringTree", "Lorg/kingdoms/utils/string/tree/StringTree;", "style", "Lorg/kingdoms/utils/string/tree/TreeStyle;", "core"})
public class StringPathBuilder {
    @NotNull
    private final LinkedHashMap<String, Object> tree;

    public StringPathBuilder(@NotNull List<String> strings) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        this.tree = new LinkedHashMap(5);
        if (strings.isEmpty()) {
            throw new IllegalArgumentException("Path string list is empty");
        }
        for (String str : strings) {
            char[] cArray = new char[]{'/'};
            LinkedList<String> sections = new LinkedList<String>(CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)str, (char[])cArray, (boolean)false, (int)0, (int)6, null)));
            this.put(this.tree, sections);
        }
    }

    protected final void put(@NotNull LinkedHashMap<String, Object> tree, @NotNull LinkedList<String> list2) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        String first = list2.removeFirst();
        boolean isFile = list2.isEmpty();
        Object previous = tree.get(first);
        LinkedHashMap<String, Object> nextTree = null;
        if (previous == null) {
            if (isFile) {
                Map map = tree;
                Intrinsics.checkNotNullExpressionValue((Object)first, (String)"first");
                map.put(first, true);
                nextTree = null;
            } else {
                nextTree = new LinkedHashMap<String, Object>();
                Map map = tree;
                Intrinsics.checkNotNullExpressionValue((Object)first, (String)"first");
                map.put(first, nextTree);
            }
        } else {
            if (isFile) {
                throw new IllegalStateException("Folder and file name are the same: " + first);
            }
            if (previous instanceof Boolean) {
                nextTree = new LinkedHashMap<String, Object>();
                Map map = tree;
                Intrinsics.checkNotNullExpressionValue((Object)first, (String)"first");
                map.put(first, nextTree);
            } else {
                nextTree = (LinkedHashMap<String, Object>)previous;
            }
        }
        if (nextTree != null) {
            this.put(nextTree, list2);
        }
    }

    private final ContainerPrinter getEntryOf(String name, LinkedHashMap<String, Object> folder) {
        ContainerPrinter entry = new ContainerPrinter(name);
        for (Map.Entry<String, Object> entry2 : folder.entrySet()) {
            Intrinsics.checkNotNullExpressionValue(entry2, (String)"folder.entries");
            String k = entry2.getKey();
            Object v = entry2.getValue();
            if (v instanceof Boolean) {
                List<EntryPrinter> list2 = entry.getChildren$core();
                Intrinsics.checkNotNullExpressionValue((Object)k, (String)"k");
                list2.add(new StringPrinter(k));
                continue;
            }
            Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type java.util.LinkedHashMap<kotlin.String, kotlin.Any>{ org.kingdoms.utils.string.tree.StringTreeKt.Folder }");
            LinkedHashMap nest = (LinkedHashMap)v;
            List<EntryPrinter> list3 = entry.getChildren$core();
            Intrinsics.checkNotNullExpressionValue((Object)k, (String)"k");
            list3.add(this.getEntryOf(k, nest));
        }
        return entry;
    }

    @NotNull
    public final ContainerPrinter build() {
        return this.getEntryOf("", this.tree);
    }

    @NotNull
    public final StringTree toStringTree(@NotNull TreeStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return new StringTree(this.build(), style);
    }
}

