/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation.blueprint;

import com.ticxo.modelengine.api.animation.blueprint.LoopMode;
import com.ticxo.modelengine.api.animation.keyframe.type.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.animation.timeline.Timeline;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlueprintAnimation {
    private final Map<String, Timeline> timelines = new HashMap<String, Timeline>();
    private final String name;
    private double length;
    private LoopMode loopMode;
    private boolean override;

    public BlueprintAnimation(String string) {
        this.name = string;
    }

    public Timeline getOrCreateTimeline(String string2) {
        return this.timelines.computeIfAbsent(string2, string -> new Timeline());
    }

    public Timeline getTimeline(String string) {
        return this.timelines.get(string);
    }

    @Nullable
    public Vector getPosition(String string, IAnimationProperty iAnimationProperty) {
        Timeline timeline = this.timelines.get(string);
        if (timeline == null) {
            return null;
        }
        return timeline.getPositionFrame(iAnimationProperty);
    }

    @NotNull
    public Vector getPositionOrZero(String string, IAnimationProperty iAnimationProperty) {
        Vector vector = this.getPosition(string, iAnimationProperty);
        if (vector == null) {
            vector = new Vector(0, 0, 0);
        }
        return vector;
    }

    @Nullable
    public EulerAngle getRotation(String string, IAnimationProperty iAnimationProperty) {
        Timeline timeline = this.timelines.get(string);
        if (timeline == null) {
            return null;
        }
        return timeline.getRotationFrame(iAnimationProperty);
    }

    @NotNull
    public EulerAngle getRotationOrZero(String string, IAnimationProperty iAnimationProperty) {
        EulerAngle eulerAngle = this.getRotation(string, iAnimationProperty);
        if (eulerAngle == null) {
            eulerAngle = EulerAngle.ZERO;
        }
        return eulerAngle;
    }

    public Vector getScale(String string, IAnimationProperty iAnimationProperty) {
        Timeline timeline = this.timelines.get(string);
        if (timeline == null) {
            return new Vector(1, 1, 1);
        }
        return timeline.getScaleFrame(iAnimationProperty);
    }

    public List<ScriptKeyframe.Script> getScripts(IAnimationProperty iAnimationProperty) {
        Timeline timeline = this.timelines.get("effects");
        if (timeline == null) {
            return null;
        }
        return timeline.getScriptFrame(iAnimationProperty);
    }

    public String getName() {
        return this.name;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double d) {
        this.length = d;
    }

    public LoopMode getLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(LoopMode loopMode) {
        this.loopMode = loopMode;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean bl) {
        this.override = bl;
    }
}

