/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation.timeline;

import com.google.common.collect.ImmutableList;
import com.ticxo.modelengine.api.animation.keyframe.AbstractKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.IKeyframeData;
import com.ticxo.modelengine.api.animation.keyframe.KeyframeType;
import com.ticxo.modelengine.api.animation.keyframe.type.ParticleKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.type.PositionKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.type.RotationKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.type.ScaleKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.type.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.type.SoundKeyframe;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.List;
import java.util.TreeMap;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Timeline {
    private final TreeMap<Double, PositionKeyframe> position = new TreeMap();
    private final TreeMap<Double, RotationKeyframe> rotation = new TreeMap();
    private final TreeMap<Double, ScaleKeyframe> scale = new TreeMap();
    private final TreeMap<Double, ParticleKeyframe> particle = new TreeMap();
    private final TreeMap<Double, SoundKeyframe> sound = new TreeMap();
    private final TreeMap<Double, ScriptKeyframe> script = new TreeMap();

    public void addPositionFrame(double d, IKeyframeData iKeyframeData, IKeyframeData iKeyframeData2, IKeyframeData iKeyframeData3, KeyframeType keyframeType) {
        this.position.put(d, new PositionKeyframe(iKeyframeData, iKeyframeData2, iKeyframeData3, keyframeType));
    }

    public void addRotationFrame(double d, IKeyframeData iKeyframeData, IKeyframeData iKeyframeData2, IKeyframeData iKeyframeData3, KeyframeType keyframeType) {
        this.rotation.put(d, new RotationKeyframe(iKeyframeData, iKeyframeData2, iKeyframeData3, keyframeType));
    }

    public void addScaleFrame(double d, IKeyframeData iKeyframeData, IKeyframeData iKeyframeData2, IKeyframeData iKeyframeData3, KeyframeType keyframeType) {
        this.scale.put(d, new ScaleKeyframe(iKeyframeData, iKeyframeData2, iKeyframeData3, keyframeType));
    }

    public void addParticleFrame(double d, List<ParticleKeyframe.Particles> list) {
        this.particle.put(d, new ParticleKeyframe((List<ParticleKeyframe.Particles>)ImmutableList.copyOf(list)));
    }

    public void addSoundFrame(double d, List<SoundKeyframe.Sounds> list) {
        this.sound.put(d, new SoundKeyframe((List<SoundKeyframe.Sounds>)ImmutableList.copyOf(list)));
    }

    public void addScriptFrame(double d, List<ScriptKeyframe.Script> list) {
        this.script.put(d, new ScriptKeyframe((List<ScriptKeyframe.Script>)ImmutableList.copyOf(list)));
    }

    public Vector getPositionFrame(IAnimationProperty iAnimationProperty) {
        double d;
        if (this.position.isEmpty()) {
            return new Vector();
        }
        double d2 = iAnimationProperty.getTime();
        if (this.position.containsKey(d2)) {
            return this.position.get(d2).getValue(iAnimationProperty).clone();
        }
        double d3 = this.getHigherKey(this.position, d2);
        if (d3 == (d = this.getLowerKey(this.position, d2))) {
            return this.position.get(d).getValue(iAnimationProperty).clone();
        }
        double d4 = (d2 - d) / (d3 - d);
        PositionKeyframe positionKeyframe = this.position.get(d3);
        PositionKeyframe positionKeyframe2 = this.position.get(d);
        switch (this.getType(positionKeyframe2, positionKeyframe)) {
            case LINEAR: {
                return TMath.lerp(positionKeyframe2.getValue(iAnimationProperty), positionKeyframe.getValue(iAnimationProperty), d4);
            }
            case SMOOTH: {
                double d5 = this.getHigherKey(this.position, d3);
                double d6 = this.getLowerKey(this.position, d);
                PositionKeyframe positionKeyframe3 = this.position.get(d5);
                PositionKeyframe positionKeyframe4 = this.position.get(d6);
                return TMath.smoothLerp(positionKeyframe4.getValue(iAnimationProperty), positionKeyframe2.getValue(iAnimationProperty), positionKeyframe.getValue(iAnimationProperty), positionKeyframe3.getValue(iAnimationProperty), d4);
            }
            case STEP: {
                return positionKeyframe2.getValue(iAnimationProperty).clone();
            }
        }
        return TMath.lerp(positionKeyframe2.getValue(iAnimationProperty), positionKeyframe.getValue(iAnimationProperty), d4);
    }

    public EulerAngle getRotationFrame(IAnimationProperty iAnimationProperty) {
        double d;
        if (this.rotation.isEmpty()) {
            return EulerAngle.ZERO;
        }
        double d2 = iAnimationProperty.getTime();
        if (this.rotation.containsKey(d2)) {
            return this.rotation.get(d2).getValue(iAnimationProperty);
        }
        double d3 = this.getHigherKey(this.rotation, d2);
        if (d3 == (d = this.getLowerKey(this.rotation, d2))) {
            return this.rotation.get(d).getValue(iAnimationProperty);
        }
        double d4 = (d2 - d) / (d3 - d);
        RotationKeyframe rotationKeyframe = this.rotation.get(d3);
        RotationKeyframe rotationKeyframe2 = this.rotation.get(d);
        switch (this.getType(rotationKeyframe2, rotationKeyframe)) {
            case LINEAR: {
                return TMath.lerp(rotationKeyframe2.getValue(iAnimationProperty), rotationKeyframe.getValue(iAnimationProperty), d4);
            }
            case SMOOTH: {
                double d5 = this.getHigherKey(this.rotation, d3);
                double d6 = this.getLowerKey(this.rotation, d);
                RotationKeyframe rotationKeyframe3 = this.rotation.get(d5);
                RotationKeyframe rotationKeyframe4 = this.rotation.get(d6);
                return TMath.smoothLerp(rotationKeyframe4.getValue(iAnimationProperty), rotationKeyframe2.getValue(iAnimationProperty), rotationKeyframe.getValue(iAnimationProperty), rotationKeyframe3.getValue(iAnimationProperty), d4);
            }
            case STEP: {
                return rotationKeyframe2.getValue(iAnimationProperty);
            }
        }
        return TMath.lerp(rotationKeyframe2.getValue(iAnimationProperty), rotationKeyframe.getValue(iAnimationProperty), d4);
    }

    public Vector getScaleFrame(IAnimationProperty iAnimationProperty) {
        double d;
        if (this.scale.isEmpty()) {
            return new Vector();
        }
        double d2 = iAnimationProperty.getTime();
        if (this.scale.containsKey(d2)) {
            return this.scale.get(d2).getValue(iAnimationProperty).clone();
        }
        double d3 = this.getHigherKey(this.scale, d2);
        if (d3 == (d = this.getLowerKey(this.scale, d2))) {
            return this.scale.get(d).getValue(iAnimationProperty).clone();
        }
        double d4 = (d2 - d) / (d3 - d);
        ScaleKeyframe scaleKeyframe = this.scale.get(d3);
        ScaleKeyframe scaleKeyframe2 = this.scale.get(d);
        switch (this.getType(scaleKeyframe2, scaleKeyframe)) {
            case LINEAR: {
                return TMath.lerp(scaleKeyframe2.getValue(iAnimationProperty), scaleKeyframe.getValue(iAnimationProperty), d4);
            }
            case SMOOTH: {
                double d5 = this.getHigherKey(this.scale, d3);
                double d6 = this.getLowerKey(this.scale, d);
                ScaleKeyframe scaleKeyframe3 = this.scale.get(d5);
                ScaleKeyframe scaleKeyframe4 = this.scale.get(d6);
                return TMath.smoothLerp(scaleKeyframe4.getValue(iAnimationProperty), scaleKeyframe2.getValue(iAnimationProperty), scaleKeyframe.getValue(iAnimationProperty), scaleKeyframe3.getValue(iAnimationProperty), d4);
            }
            case STEP: {
                return scaleKeyframe2.getValue(iAnimationProperty).clone();
            }
        }
        return TMath.lerp(scaleKeyframe2.getValue(iAnimationProperty), scaleKeyframe.getValue(iAnimationProperty), d4);
    }

    public List<ParticleKeyframe.Particles> getParticlesFrame(IAnimationProperty iAnimationProperty) {
        if (this.particle.isEmpty()) {
            return null;
        }
        double d = iAnimationProperty.getTime();
        if (this.particle.containsKey(d)) {
            return (List)this.particle.get(d).getValue(iAnimationProperty);
        }
        double d2 = this.getHigherKey(this.particle, d);
        double d3 = this.getLowerKey(this.particle, d);
        if (Math.abs(d - d3) < 0.025) {
            return (List)this.particle.get(d3).getValue(iAnimationProperty);
        }
        if (Math.abs(d2 - d) < 0.025) {
            return (List)this.particle.get(d2).getValue(iAnimationProperty);
        }
        return null;
    }

    public List<SoundKeyframe.Sounds> getSoundsFrame(IAnimationProperty iAnimationProperty) {
        if (this.sound.isEmpty()) {
            return null;
        }
        double d = iAnimationProperty.getTime();
        if (this.sound.containsKey(d)) {
            return (List)this.sound.get(d).getValue(iAnimationProperty);
        }
        double d2 = this.getHigherKey(this.sound, d);
        double d3 = this.getLowerKey(this.sound, d);
        if (Math.abs(d - d3) < 0.025) {
            return (List)this.sound.get(d3).getValue(iAnimationProperty);
        }
        if (Math.abs(d2 - d) < 0.025) {
            return (List)this.sound.get(d2).getValue(iAnimationProperty);
        }
        return null;
    }

    public List<ScriptKeyframe.Script> getScriptFrame(IAnimationProperty iAnimationProperty) {
        if (this.script.isEmpty()) {
            return null;
        }
        double d = iAnimationProperty.getTime();
        if (this.script.containsKey(d)) {
            return (List)this.script.get(d).getValue(iAnimationProperty);
        }
        double d2 = this.getHigherKey(this.script, d);
        double d3 = this.getLowerKey(this.script, d);
        if (Math.abs(d - d3) < 0.025) {
            return (List)this.script.get(d3).getValue(iAnimationProperty);
        }
        if (Math.abs(d2 - d) < 0.025) {
            return (List)this.script.get(d2).getValue(iAnimationProperty);
        }
        return null;
    }

    private double getHigherKey(TreeMap<Double, ?> treeMap, double d) {
        Double d2 = treeMap.higherKey(d);
        if (d2 == null) {
            return treeMap.lastKey();
        }
        return d2;
    }

    private double getLowerKey(TreeMap<Double, ?> treeMap, double d) {
        Double d2 = treeMap.lowerKey(d);
        if (d2 == null) {
            return treeMap.firstKey();
        }
        return d2;
    }

    private KeyframeType getType(AbstractKeyframe<?> abstractKeyframe, AbstractKeyframe<?> abstractKeyframe2) {
        if (abstractKeyframe.getType() == KeyframeType.STEP) {
            return KeyframeType.STEP;
        }
        if (abstractKeyframe.getType() == KeyframeType.SMOOTH || abstractKeyframe2.getType() == KeyframeType.SMOOTH) {
            return KeyframeType.SMOOTH;
        }
        return KeyframeType.LINEAR;
    }
}

