/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.command;

import com.ticxo.modelengine.api.ModelEngineAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommand
implements TabExecutor {
    protected final ModelEngineAPI plugin;
    private final Map<String, AbstractCommand> subCommands = new HashMap<String, AbstractCommand>();
    private final Map<String, AbstractCommand> subCommandAliases = new HashMap<String, AbstractCommand>();

    public AbstractCommand(AbstractCommand abstractCommand) {
        this(abstractCommand.getPlugin());
    }

    public AbstractCommand(ModelEngineAPI modelEngineAPI) {
        this.plugin = modelEngineAPI;
    }

    public final void addSubCommands(AbstractCommand ... abstractCommandArray) {
        for (AbstractCommand abstractCommand : abstractCommandArray) {
            this.subCommands.put(abstractCommand.getName(), abstractCommand);
            for (String string : abstractCommand.getAliases()) {
                this.subCommandAliases.put(string, abstractCommand);
            }
        }
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String string, String[] stringArray) {
        if (this.getPermissionNode() != null && !commandSender.hasPermission(this.getPermissionNode()) && !commandSender.hasPermission("modelengine.admin")) {
            commandSender.sendMessage(ChatColor.RED + "You don't have permission to do this!");
            return true;
        }
        if (!this.isConsoleFriendly() && !(commandSender instanceof Player)) {
            commandSender.sendMessage(ChatColor.RED + "Only players can do this!");
            return true;
        }
        if (stringArray.length > 0 && this.subCommands.get(stringArray[0].toLowerCase()) != null) {
            AbstractCommand abstractCommand = this.subCommands.get(stringArray[0].toLowerCase());
            return abstractCommand.onCommand(commandSender, command, string, Arrays.copyOfRange(stringArray, 1, stringArray.length));
        }
        if (stringArray.length > 0 && this.subCommandAliases.get(stringArray[0].toLowerCase()) != null) {
            AbstractCommand abstractCommand = this.subCommandAliases.get(stringArray[0].toLowerCase());
            return abstractCommand.onCommand(commandSender, command, string, Arrays.copyOfRange(stringArray, 1, stringArray.length));
        }
        return this.onCommand(commandSender, stringArray);
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String string, String[] stringArray) {
        if (this.getPermissionNode() != null && !commandSender.hasPermission(this.getPermissionNode())) {
            return null;
        }
        if (stringArray.length > 1 && this.subCommands.get(stringArray[0].toLowerCase()) != null) {
            AbstractCommand abstractCommand = this.subCommands.get(stringArray[0].toLowerCase());
            return abstractCommand.onTabComplete(commandSender, command, string, Arrays.copyOfRange(stringArray, 1, stringArray.length));
        }
        if (stringArray.length > 1 && this.subCommandAliases.get(stringArray[0].toLowerCase()) != null) {
            AbstractCommand abstractCommand = this.subCommandAliases.get(stringArray[0].toLowerCase());
            return abstractCommand.onTabComplete(commandSender, command, string, Arrays.copyOfRange(stringArray, 1, stringArray.length));
        }
        List<String> list = this.onTabComplete(commandSender, stringArray);
        if (list == null && stringArray.length == 1) {
            list = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)stringArray[0], this.subCommands.keySet(), list);
        }
        return list;
    }

    public abstract boolean onCommand(CommandSender var1, String[] var2);

    public abstract List<String> onTabComplete(CommandSender var1, String[] var2);

    public abstract String getPermissionNode();

    public abstract boolean isConsoleFriendly();

    public String[] getAliases() {
        return new String[0];
    }

    public abstract String getName();

    protected ModelEngineAPI getPlugin() {
        return this.plugin;
    }
}

