/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.generator.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.animation.blueprint.BlueprintAnimation;
import com.ticxo.modelengine.api.error.IError;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

public class ModelBlueprint {
    private String modelId;
    private Hitbox mainHitbox;
    private final Map<String, Hitbox> subHitboxes = Maps.newConcurrentMap();
    private final Map<String, Integer> itemIds = Maps.newConcurrentMap();
    private final Map<String, BlueprintBone> bones = Maps.newConcurrentMap();
    private final transient Map<UUID, String> finalBoneNames = Maps.newConcurrentMap();
    private final Map<String, BlueprintAnimation> animations = Maps.newLinkedHashMap();
    private final Map<String, String> animationsPlaceholders = Maps.newLinkedHashMap();
    private transient Map<String, BlueprintBone> flatMap;

    public void constructFlatBoneMap() {
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        HashSet<BlueprintBone> hashSet = new HashSet<BlueprintBone>(this.bones.values());
        HashSet<BlueprintBone> hashSet2 = new HashSet<BlueprintBone>();
        while (!hashSet.isEmpty()) {
            for (BlueprintBone blueprintBone : hashSet) {
                hashSet2.addAll(blueprintBone.getChildren());
                if (concurrentMap.containsKey(blueprintBone.getName())) {
                    IError.DUPE_NAME.log();
                    continue;
                }
                concurrentMap.put(blueprintBone.getName(), blueprintBone);
            }
            hashSet.clear();
            hashSet.addAll(hashSet2);
            hashSet2.clear();
        }
        this.flatMap = ImmutableMap.copyOf((Map)concurrentMap);
    }

    public String getModelId() {
        return this.modelId;
    }

    public Hitbox getMainHitbox() {
        return this.mainHitbox;
    }

    public Map<String, Hitbox> getSubHitboxes() {
        return this.subHitboxes;
    }

    public Map<String, Integer> getItemIds() {
        return this.itemIds;
    }

    public Map<String, BlueprintBone> getBones() {
        return this.bones;
    }

    public Map<UUID, String> getFinalBoneNames() {
        return this.finalBoneNames;
    }

    public Map<String, BlueprintAnimation> getAnimations() {
        return this.animations;
    }

    public Map<String, String> getAnimationsPlaceholders() {
        return this.animationsPlaceholders;
    }

    public void setModelId(String string) {
        this.modelId = string;
    }

    public void setMainHitbox(Hitbox hitbox) {
        this.mainHitbox = hitbox;
    }

    public Map<String, BlueprintBone> getFlatMap() {
        return this.flatMap;
    }
}

