/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.model.handler;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.entity.Player;

public abstract class AbstractSpecialBoneHandler<T extends ModelBone, R extends FakeEntity> {
    protected final ActiveModel model;
    protected final Map<String, T> bones = Maps.newConcurrentMap();
    protected final Map<String, R> fakeEntity = Maps.newConcurrentMap();

    public AbstractSpecialBoneHandler(ActiveModel activeModel) {
        this.model = activeModel;
    }

    public abstract void registerSpecialBone(T var1);

    public void unregisterSpecialBone(String string) {
        this.bones.remove(string);
        this.fakeEntity.remove(string);
    }

    public void initialize() {
        this.fakeEntity.values().forEach((? super T fakeEntity) -> {
            fakeEntity.initialize();
            fakeEntity.spawn();
        });
    }

    public void spawn() {
        this.fakeEntity.values().forEach(FakeEntity::spawn);
    }

    public void spawn(Player player) {
        try {
            this.fakeEntity.values().forEach((? super T fakeEntity) -> fakeEntity.spawn(player));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void despawn() {
        this.fakeEntity.values().forEach(FakeEntity::despawn);
    }

    public void despawn(Player player) {
        this.fakeEntity.values().forEach((? super T fakeEntity) -> fakeEntity.despawn(player));
    }

    public void update() {
        this.fakeEntity.values().forEach(FakeEntity::update);
    }

    public void updateReference() {
        this.bones.keySet().forEach((? super T string) -> {
            ModelBone modelBone = (ModelBone)this.bones.get(string);
            FakeEntity fakeEntity = (FakeEntity)this.fakeEntity.get(string);
            fakeEntity.setBone(modelBone);
        });
    }

    protected void forEach(BiConsumer<T, R> biConsumer) {
        for (Map.Entry<String, T> entry : this.bones.entrySet()) {
            FakeEntity fakeEntity = (FakeEntity)this.fakeEntity.get(entry.getKey());
            if (fakeEntity == null) continue;
            biConsumer.accept((ModelBone)entry.getValue(), fakeEntity);
        }
    }

    public ActiveModel getModel() {
        return this.model;
    }

    public Map<String, T> getBones() {
        return this.bones;
    }

    public Map<String, R> getFakeEntity() {
        return this.fakeEntity;
    }
}

