/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.mount;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.command.annotations.CommandAttribute;
import com.ticxo.modelengine.api.events.ModelDismountEvent;
import com.ticxo.modelengine.api.events.ModelMountEvent;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Mountable;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CommandAccessible
public class MountManager {
    private final ModeledEntity model;
    private boolean canSteer = true;
    private boolean canRide = true;
    private Entity driver = null;
    private Mountable driverBone;
    private MountController driverController;
    private final Map<Entity, Mountable> passengers = Maps.newConcurrentMap();
    private final Map<UUID, MountController> controllers = Maps.newConcurrentMap();
    private final Set<UUID> nullifyDamage = Sets.newConcurrentHashSet();

    public MountManager(ModeledEntity modeledEntity) {
        this.model = modeledEntity;
    }

    @CommandAttribute(tag="steer", hints={"[B]flag"})
    public void setCanSteer(boolean bl) {
        this.canSteer = bl;
    }

    @CommandAttribute(tag="ride", hints={"[B]flag"})
    public void setCanRide(boolean bl) {
        this.canRide = bl;
    }

    public void setDriverBone(Mountable mountable) {
        if (mountable.isDriverBone()) {
            this.driverBone = mountable;
        }
    }

    @CommandAttribute(tag="drive", hints={"[P]driver", "[C]controller"})
    public void setDriver(@NotNull Entity entity, MountController mountController) {
        if (!this.canSteer || this.driverBone == null) {
            return;
        }
        if (ModelEngineAPI.getMountPair(entity.getUniqueId()) != null) {
            throw new IllegalStateException("Please dismount the rider before mounting it onto a different model.");
        }
        ModelMountEvent modelMountEvent = new ModelMountEvent(this.model, entity, true, this.driverBone);
        ModelEngineAPI.callEvent(modelMountEvent);
        if (modelMountEvent.isCancelled()) {
            return;
        }
        if (this.driver != null) {
            this.removeDriver();
        }
        this.driver = entity;
        mountController.setEntity(entity);
        mountController.setMountable(this.driverBone);
        this.driverController = mountController;
        this.registerPair(entity, mountController);
        this.driverBone.mountRiders(entity);
        this.setCollidable(entity, false);
    }

    @CommandAttribute(tag="remove_driver")
    public void removeDriver() {
        if (this.driver == null || this.driverBone == null) {
            return;
        }
        ModelDismountEvent modelDismountEvent = new ModelDismountEvent(this.model, this.driver, true, this.driverBone);
        ModelEngineAPI.callEvent(modelDismountEvent);
        if (modelDismountEvent.isCancelled()) {
            return;
        }
        this.driverBone.dismountRider(this.driver);
        this.setCanDamageMount(this.driver, true);
        this.setCollidable(this.driver, true);
        this.unregisterPair(this.driver);
        this.driverController = null;
        this.driver = null;
    }

    public boolean isControlled() {
        return this.driver != null;
    }

    @CommandAttribute(tag="sit", hints={"[S]modelId", "[S]seatId", "[P]passenger", "[C]controller"})
    public void addPassengerToSeat(String string, String string2, Entity entity, MountController mountController) {
        if (!this.canRide) {
            return;
        }
        if (ModelEngineAPI.getMountPair(entity.getUniqueId()) != null) {
            throw new IllegalStateException("Please dismount the rider before mounting it onto a different model.");
        }
        Mountable mountable = this.getMountable(string, string2);
        if (mountable == null || mountable.isDriverBone()) {
            return;
        }
        ModelMountEvent modelMountEvent = new ModelMountEvent(this.model, entity, false, mountable);
        ModelEngineAPI.callEvent(modelMountEvent);
        if (modelMountEvent.isCancelled()) {
            return;
        }
        mountable.mountRiders(entity);
        this.passengers.put(entity, mountable);
        mountController.setEntity(entity);
        mountController.setMountable(mountable);
        this.controllers.put(entity.getUniqueId(), mountController);
        this.registerPair(entity, mountController);
        this.setCollidable(entity, false);
    }

    public void removePassenger(Entity entity) {
        Mountable mountable = this.passengers.get(entity);
        if (mountable == null) {
            return;
        }
        ModelDismountEvent modelDismountEvent = new ModelDismountEvent(this.model, entity, false, mountable);
        ModelEngineAPI.callEvent(modelDismountEvent);
        if (modelDismountEvent.isCancelled()) {
            return;
        }
        mountable.dismountRider(entity);
        this.removePassengerReference(entity);
        this.unregisterPair(entity);
        this.setCanDamageMount(entity, true);
        this.setCollidable(entity, true);
    }

    public void removePassengers(Entity ... entityArray) {
        for (Entity entity : entityArray) {
            this.removePassenger(entity);
        }
    }

    public void removePassengersOnSeat(String string, String string2, Entity ... entityArray) {
        Mountable mountable = this.getMountable(string, string2);
        if (mountable == null) {
            return;
        }
        Set<Entity> set = mountable.getRiders();
        for (Entity entity : entityArray) {
            if (!set.contains(entity)) continue;
            ModelDismountEvent modelDismountEvent = new ModelDismountEvent(this.model, entity, false, mountable);
            ModelEngineAPI.callEvent(modelDismountEvent);
            if (modelDismountEvent.isCancelled()) continue;
            mountable.dismountRider(entity);
            this.removePassengerReference(entity);
            this.unregisterPair(entity);
            this.setCanDamageMount(entity, true);
            this.setCollidable(entity, true);
        }
    }

    public void clearPassengersOnSeat(String string, String string2) {
        Mountable mountable = this.getMountable(string, string2);
        if (mountable == null) {
            return;
        }
        for (Entity entity : mountable.getRiders()) {
            ModelDismountEvent modelDismountEvent = new ModelDismountEvent(this.model, entity, false, mountable);
            ModelEngineAPI.callEvent(modelDismountEvent);
            this.removePassengerReference(entity);
            this.unregisterPair(entity);
            this.setCanDamageMount(entity, true);
            this.setCollidable(entity, true);
        }
        mountable.clearRiders();
    }

    @CommandAttribute(tag="dismount_all")
    public void dismountAll() {
        this.removeDriver();
        this.dismountAllPassengers();
    }

    @CommandAttribute(tag="dismount_all_passengers")
    public void dismountAllPassengers() {
        Set set = Sets.newConcurrentHashSet();
        set.addAll(this.passengers.values());
        set.forEach(Mountable::clearRiders);
        this.passengers.keySet().forEach(entity -> {
            this.unregisterPair((Entity)entity);
            this.setCanDamageMount((Entity)entity, true);
            this.setCollidable((Entity)entity, true);
        });
        this.passengers.clear();
        this.controllers.clear();
    }

    public void removeRiders(Entity ... entityArray) {
        for (Entity entity : entityArray) {
            if (entity == this.driver) {
                this.removeDriver();
                continue;
            }
            this.removePassenger(entity);
        }
    }

    public boolean hasRider(Entity entity) {
        return this.driver == entity || this.passengers.containsKey(entity);
    }

    @Deprecated(since="R3.1.5")
    public void setCanDamageMount(UUID uUID, boolean bl) {
        if (bl) {
            this.nullifyDamage.remove(uUID);
        } else {
            this.nullifyDamage.add(uUID);
        }
    }

    public void setCanDamageMount(Entity entity, boolean bl) {
        block4: {
            block3: {
                if (!bl) break block3;
                this.nullifyDamage.remove(entity.getUniqueId());
                Entity entity2 = entity;
                if (!(entity2 instanceof Player)) break block4;
                Player player = (Player)entity2;
                this.model.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)modelHitbox -> modelHitbox.spawn(player)));
                for (ActiveModel activeModel : this.model.getModels().values()) {
                    activeModel.getSubHitboxHandler().spawn(player);
                }
                break block4;
            }
            this.nullifyDamage.add(entity.getUniqueId());
            Entity entity3 = entity;
            if (entity3 instanceof Player) {
                Player player = (Player)entity3;
                this.model.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)modelHitbox -> modelHitbox.despawn(player)));
                for (ActiveModel activeModel : this.model.getModels().values()) {
                    activeModel.getSubHitboxHandler().despawn(player);
                }
            }
        }
    }

    public boolean isDamageNullified(UUID uUID) {
        return this.nullifyDamage.contains(uUID);
    }

    public Set<Entity> getPassengersOnSeat(String string, String string2) {
        Mountable mountable = this.getMountable(string, string2);
        return mountable == null ? ImmutableSet.of() : mountable.getRiders();
    }

    public boolean hasPassengers() {
        return !this.passengers.isEmpty();
    }

    public Map<Entity, Mountable> getPassengers() {
        return ImmutableMap.copyOf(this.passengers);
    }

    @Nullable
    public Mountable getMountedBone(Entity entity) {
        if (this.driver == entity) {
            return this.driverBone;
        }
        return this.passengers.get(entity);
    }

    @Nullable
    public Mountable getMountedBone(UUID uUID) {
        if (this.driver == null) {
            return null;
        }
        if (this.driver.getUniqueId().equals(uUID)) {
            return this.driverBone;
        }
        MountController mountController = this.controllers.get(uUID);
        if (mountController == null) {
            return null;
        }
        return mountController.getMountable();
    }

    public MountController getController(UUID uUID) {
        return this.controllers.get(uUID);
    }

    protected void registerPair(Entity entity, MountController mountController) {
        ModelEngineAPI.registerMountedPair(entity, this.model, mountController);
    }

    protected void unregisterPair(Entity entity) {
        ModelEngineAPI.unregisterMountedPair(entity.getUniqueId());
    }

    protected void setCollidable(Entity entity, boolean bl) {
        Entity entity2 = entity;
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            this.model.getBase().setCollidableToLiving(livingEntity, bl);
        }
    }

    protected void removePassengerReference(Entity entity) {
        this.passengers.remove(entity);
        this.controllers.remove(entity.getUniqueId());
    }

    @Nullable
    protected Mountable getMountable(String string, String string2) {
        ActiveModel activeModel = this.model.getModel(string);
        if (activeModel == null) {
            return null;
        }
        return (Mountable)activeModel.getMountHandler().getBones().get(string2);
    }

    public ModeledEntity getModel() {
        return this.model;
    }

    public boolean isCanSteer() {
        return this.canSteer;
    }

    public boolean isCanRide() {
        return this.canRide;
    }

    public Entity getDriver() {
        return this.driver;
    }

    public Mountable getDriverBone() {
        return this.driverBone;
    }

    public MountController getDriverController() {
        return this.driverController;
    }
}

