/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.mount.controller.flying;

import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.controller.AbstractMountController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import org.bukkit.util.Vector;

public class FlyingMountController
extends AbstractMountController {
    @Override
    public void updateDriverMovement(MoveController moveController, ModeledEntity modeledEntity) {
        moveController.nullifyFallDistance();
        Vector vector = moveController.getVelocity();
        moveController.setVelocity(vector.getX(), 0.0, vector.getZ());
        BaseEntity<?> baseEntity = modeledEntity.getBase();
        if (this.input.isSneak()) {
            if (!moveController.isOnGround()) {
                moveController.addVelocity(0.0, -moveController.getSpeed(), 0.0);
            } else {
                modeledEntity.getMountManager().removeDriver();
                moveController.move(0.0f, 0.0f, 0.0f);
                return;
            }
        }
        if (this.input.isJump()) {
            moveController.addVelocity(0.0, moveController.getSpeed(), 0.0);
        }
        moveController.move(this.input.getSide(), this.input.getFront(), 1.0f);
        if (this.input.getSide() != 0.0f || this.input.getFront() != 0.0f) {
            modeledEntity.setState(ModelState.WALK);
        } else {
            modeledEntity.setState(ModelState.IDLE);
        }
    }

    @Override
    public void updatePassengerMovement(MoveController moveController, ModeledEntity modeledEntity) {
        if (this.input.isSneak() && modeledEntity.getBase().isOnGround()) {
            modeledEntity.getMountManager().removePassengers(this.entity);
        }
    }
}

