/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.nms.entity.impl;

import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.utils.math.TMath;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;

@CommandAccessible(value={BodyRotationController.class})
public class DefaultBodyRotationController
implements BodyRotationController {
    private final BaseEntity<?> entity;
    private float headYaw;
    private float bodyYaw;
    private boolean isHeadClampUneven;
    private boolean isBodyClampUneven;
    private float maxHeadAngle;
    private float maxBodyAngle;
    private float minHeadAngle;
    private float minBodyAngle;
    private boolean playerMode;
    private float stableAngle = 15.0f;
    private int rotationDelay = 10;
    private int rotationDuration = 10;
    private int headStableTime;
    private float lastStableYHeadRot;

    public DefaultBodyRotationController(BaseEntity<?> baseEntity) {
        this.entity = baseEntity;
        this.headYaw = baseEntity.getYHeadRot();
        this.bodyYaw = baseEntity.getYBodyRot();
    }

    @Override
    public void tick() {
        this.headYaw = this.getYHeadRot();
        if (this.entity.isMoving()) {
            this.bodyYaw = this.entity.getLocation().getYaw();
            this.rotateHeadIfNecessary();
            this.lastStableYHeadRot = this.headYaw;
            this.headStableTime = 0;
        } else if (this.notCarryingMobPassengers()) {
            if (Math.abs(this.headYaw - this.lastStableYHeadRot) > this.stableAngle) {
                this.headStableTime = 0;
                this.lastStableYHeadRot = this.headYaw;
                this.rotateBodyIfNecessary();
            } else if (!this.playerMode) {
                ++this.headStableTime;
                if (this.headStableTime > this.rotationDelay) {
                    this.rotateHeadTowardsFront();
                }
            }
        }
    }

    @Override
    public void setYHeadRot(float f) {
    }

    @Override
    public float getYHeadRot() {
        return this.entity.getYHeadRot();
    }

    @Override
    public float getXHeadRot() {
        return this.entity.getXHeadRot();
    }

    @Override
    public void setYBodyRot(float f) {
    }

    @Override
    public float getYBodyRot() {
        return this.bodyYaw;
    }

    private void rotateBodyIfNecessary() {
        this.bodyYaw = TMath.rotateIfNecessary(this.bodyYaw, this.headYaw, this.isBodyClampUneven ? this.minBodyAngle : -this.maxBodyAngle, this.maxBodyAngle);
    }

    private void rotateHeadIfNecessary() {
        this.headYaw = TMath.rotateIfNecessary(this.headYaw, this.bodyYaw, this.isHeadClampUneven ? this.minHeadAngle : -this.maxHeadAngle, this.maxHeadAngle);
    }

    private void rotateHeadTowardsFront() {
        float f = (float)(this.headStableTime - this.rotationDelay) / (float)this.rotationDuration;
        float f2 = TMath.clamp(f, 0.0f, 1.0f);
        float f3 = this.maxHeadAngle * (1.0f - f2);
        float f4 = (this.isHeadClampUneven ? this.minHeadAngle : -this.maxHeadAngle) * (1.0f - f2);
        this.bodyYaw = TMath.rotateIfNecessary(this.bodyYaw, this.headYaw, f4, f3);
    }

    private boolean notCarryingMobPassengers() {
        for (Entity entity : this.entity.getPassengers()) {
            if (!(entity instanceof Mob)) continue;
            return false;
        }
        return true;
    }

    public float getHeadYaw() {
        return this.headYaw;
    }

    public float getBodyYaw() {
        return this.bodyYaw;
    }

    @Override
    public boolean isHeadClampUneven() {
        return this.isHeadClampUneven;
    }

    @Override
    public void setHeadClampUneven(boolean bl) {
        this.isHeadClampUneven = bl;
    }

    @Override
    public boolean isBodyClampUneven() {
        return this.isBodyClampUneven;
    }

    @Override
    public void setBodyClampUneven(boolean bl) {
        this.isBodyClampUneven = bl;
    }

    @Override
    public float getMaxHeadAngle() {
        return this.maxHeadAngle;
    }

    @Override
    public void setMaxHeadAngle(float f) {
        this.maxHeadAngle = f;
    }

    @Override
    public float getMaxBodyAngle() {
        return this.maxBodyAngle;
    }

    @Override
    public void setMaxBodyAngle(float f) {
        this.maxBodyAngle = f;
    }

    @Override
    public float getMinHeadAngle() {
        return this.minHeadAngle;
    }

    @Override
    public void setMinHeadAngle(float f) {
        this.minHeadAngle = f;
    }

    @Override
    public float getMinBodyAngle() {
        return this.minBodyAngle;
    }

    @Override
    public void setMinBodyAngle(float f) {
        this.minBodyAngle = f;
    }

    @Override
    public boolean isPlayerMode() {
        return this.playerMode;
    }

    @Override
    public void setPlayerMode(boolean bl) {
        this.playerMode = bl;
    }

    @Override
    public float getStableAngle() {
        return this.stableAngle;
    }

    @Override
    public void setStableAngle(float f) {
        this.stableAngle = f;
    }

    @Override
    public int getRotationDelay() {
        return this.rotationDelay;
    }

    @Override
    public void setRotationDelay(int n) {
        this.rotationDelay = n;
    }

    @Override
    public int getRotationDuration() {
        return this.rotationDuration;
    }

    @Override
    public void setRotationDuration(int n) {
        this.rotationDuration = n;
    }
}

