/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.nms.entity.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.model.IModel;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import java.util.Set;
import org.bukkit.entity.Player;

public class ManualRangeManager
implements RangeManager {
    private final BaseEntity<?> base;
    private final IModel model;
    private final Set<Player> players = Sets.newConcurrentHashSet();
    private int renderDistance;

    public ManualRangeManager(BaseEntity<?> baseEntity, IModel iModel) {
        this.base = baseEntity;
        this.model = iModel;
    }

    @Override
    public void forceSpawn(Player player) {
        if (this.players.contains(player)) {
            return;
        }
        this.players.add(player);
        this.model.showToPlayer(player);
    }

    @Override
    public void updatePlayer(Player player) {
        double d = player.getLocation().distanceSquared(this.base.getLocation());
        if (d > (double)(this.renderDistance * this.renderDistance)) {
            this.removePlayer(player);
        } else {
            this.forceSpawn(player);
        }
    }

    @Override
    public void removePlayer(Player player) {
        if (!this.players.contains(player)) {
            return;
        }
        this.players.remove(player);
        this.model.hideFromPlayer(player);
    }

    @Override
    public Set<Player> getPlayerInRange() {
        return ImmutableSet.copyOf(this.players);
    }

    @Override
    public void addTrackedPlayer(Player player) {
        this.players.add(player);
    }

    @Override
    public void removeTrackedPlayer(Player player) {
        this.players.add(player);
    }

    public IModel getModel() {
        return this.model;
    }

    @Override
    public int getRenderDistance() {
        return this.renderDistance;
    }

    @Override
    public void setRenderDistance(int n) {
        this.renderDistance = n;
    }
}

