/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class FieldUtils {
    private static final Map<Class<?>, ConcurrentHashMap<String, Field>> fieldMap = Maps.newConcurrentMap();

    public static void unlockField(Class<?> clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            ConcurrentHashMap<String, Field> concurrentHashMap = fieldMap.get(clazz);
            if (concurrentHashMap == null) {
                concurrentHashMap = new ConcurrentHashMap();
            }
            concurrentHashMap.put(string, field);
            fieldMap.put(clazz, concurrentHashMap);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
        }
    }

    public static Field getField(Class<?> clazz, String string) {
        if (!fieldMap.containsKey(clazz) || !fieldMap.get(clazz).containsKey(string)) {
            FieldUtils.unlockField(clazz, string);
        }
        return fieldMap.get(clazz).get(string);
    }

    public static Field getField(Class<?> clazz, FieldEnums fieldEnums) {
        return FieldUtils.getField(clazz, fieldEnums.getField());
    }

    public static boolean setField(Class<?> clazz, FieldEnums fieldEnums, Object object, Object object2) {
        try {
            FieldUtils.getField(clazz, fieldEnums).set(object, object2);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return false;
        }
    }

    @Nullable
    public static <T> T get(Class<?> clazz, FieldEnums fieldEnums, Object object) {
        try {
            return (T)FieldUtils.getField(clazz, fieldEnums).get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    public static interface FieldEnums {
        public String getField();
    }
}

