/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.config;

import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.utils.config.Property;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    private final JavaPlugin plugin;
    private final Map<String, Object> config = new LinkedHashMap<String, Object>();
    private final Set<Runnable> updater = Sets.newConcurrentHashSet();
    private FileConfiguration file;

    public ConfigManager(JavaPlugin javaPlugin) {
        this.plugin = javaPlugin;
        this.file = javaPlugin.getConfig();
        javaPlugin.saveDefaultConfig();
    }

    public void register(Property property) {
        if (property.getDef() == null) {
            return;
        }
        this.register(property.getPath(), property.getDef());
    }

    public void register(String string, @NotNull Object object) {
        this.config.put(string, this.file.get(string, object));
    }

    public void registerReferenceUpdate(Runnable runnable) {
        this.updater.add(runnable);
        runnable.run();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.file = this.plugin.getConfig();
        this.config.replaceAll((string, object) -> this.file.get(string, this.config.get(string)));
    }

    public void updateReferences() {
        this.updater.forEach(Runnable::run);
    }

    public <T> T get(String string) {
        try {
            return (T)this.config.get(string);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public <T> T get(Property property) {
        return this.get(property.getPath());
    }

    public int getInt(Property property) {
        return (Integer)this.get(property);
    }

    public double getDouble(Property property) {
        Object t = this.get(property);
        Object t2 = t;
        if (t2 instanceof Number) {
            Number number = (Number)t2;
            return number.doubleValue();
        }
        return 0.0;
    }

    public String getString(Property property) {
        return (String)this.get(property);
    }

    public boolean getBoolean(Property property) {
        return (Boolean)this.get(property);
    }

    public void save() {
        this.config.forEach((arg_0, arg_1) -> ((FileConfiguration)this.file).set(arg_0, arg_1));
        this.plugin.saveConfig();
    }
}

