/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.config;

import com.ticxo.modelengine.api.utils.config.Property;
import org.jetbrains.annotations.Nullable;

public enum ConfigProperty implements Property
{
    ENGINE("Model-Engine"),
    GENERATOR("Model-Generator"),
    CALIBRATOR("Model-Calibrator"),
    EXPERIMENTAL("Experimental-Features"),
    SLERP_MODE(ENGINE, "Slerp-Mode", "SLERP"),
    DEFAULT_NAMES(ENGINE, "Default-Animations"),
    ANIMATION_MODE(ENGINE, "Animation-Mode", "B"),
    MOVE_RESOLUTION(ENGINE, "Movement-Resolution", 0.001),
    COMPRESS_PACKET(ENGINE, "Compress-Packet", true),
    LATE_REGISTER(GENERATOR, "Register-Post-Server", true),
    LATE_ASSETS(GENERATOR, "Assets-Post-Server", true),
    ERROR(GENERATOR, "Enable-Error", true),
    DEBUG_LEVEL(GENERATOR, "Debug-Level", 1),
    NAMESPACE(GENERATOR, "Namespace", "modelengine"),
    COMPARTMENT_SIZE(GENERATOR, "Compartment-Size", 1000),
    ZIP(GENERATOR, "Create-Zip", true),
    ITEM_MODEL(GENERATOR, "Item-Model", "LEATHER_HORSE_ARMOR"),
    USE_CALIBRATION(CALIBRATOR, "Use-Calibration", true),
    CAL_ANIMATION(CALIBRATOR, "Animation-Sync", 0.685),
    METRICS("Enable-Metrics", true);

    private final String path;
    private final Object def;

    private ConfigProperty(String string2) {
        this(string2, null);
    }

    private ConfigProperty(ConfigProperty configProperty, String string2) {
        this(configProperty.getPath() + "." + string2, null);
    }

    private ConfigProperty(String string2, Object object) {
        this.path = string2;
        this.def = object;
    }

    private ConfigProperty(@Nullable ConfigProperty configProperty, String string2, Object object) {
        this(configProperty.getPath() + "." + string2, object);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Object getDef() {
        return this.def;
    }
}

