/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.logger;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.logger.LogColor;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class TLogger {
    public static void log() {
        TLogger.log("");
    }

    public static void log(String string) {
        TLogger.log(1, string);
    }

    public static void log(int n, String string) {
        if (ConfigProperty.DEBUG_LEVEL.getInt() >= n) {
            ModelEngineAPI.api.getLogger().log(Level.INFO, TLogger.getThread() + string + LogColor.RESET);
        }
    }

    public static void warn(String string) {
        TLogger.warn(1, string);
    }

    public static void warn(int n, String string) {
        if (ConfigProperty.DEBUG_LEVEL.getInt() >= n) {
            ModelEngineAPI.api.getLogger().log(Level.WARNING, TLogger.getThread() + LogColor.YELLOW + string + LogColor.RESET);
        }
    }

    public static void error(String string) {
        TLogger.error(1, string);
    }

    public static void error(int n, String string) {
        if (ConfigProperty.DEBUG_LEVEL.getInt() >= n) {
            ModelEngineAPI.api.getLogger().log(Level.WARNING, TLogger.getThread() + LogColor.RED + string + LogColor.RESET);
        }
    }

    public static void log(Object object) {
        TLogger.log(object == null ? "null" : object.toString());
    }

    public static <T> void log(Iterable<T> iterable) {
        TLogger.log(iterable, Object::toString);
    }

    public static <T> void log(Iterable<T> iterable, Function<T, String> function) {
        String string = iterable.getClass().getSimpleName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(":[");
        boolean bl = true;
        for (T t : iterable) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(function.apply(t));
        }
        stringBuilder.append("]");
        TLogger.log(stringBuilder.toString());
    }

    public static <T> void log(T[] TArray) {
        TLogger.log(TArray, Objects::toString);
    }

    public static <T> void log(T[] TArray, Function<T, String> function) {
        String string = TArray.getClass().getSimpleName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(":[");
        boolean bl = true;
        for (T t : TArray) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(function.apply(t));
        }
        stringBuilder.append("]");
        TLogger.log(stringBuilder.toString());
    }

    private static String getThread() {
        return Bukkit.getServer().isPrimaryThread() ? "[S] " : "[A] ";
    }
}

