/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.math;

import com.ticxo.modelengine.api.utils.math.Quaternion;
import com.ticxo.modelengine.api.utils.math.TMath;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Matrix3x3 {
    private double m11;
    private double m12;
    private double m13;
    private double m21;
    private double m22;
    private double m23;
    private double m31;
    private double m32;
    private double m33;

    public Matrix3x3() {
    }

    public void setRow(int n, Vector vector) {
        this.setRow(n, vector.getX(), vector.getY(), vector.getZ());
    }

    public void setRow(int n, double d, double d2, double d3) {
        switch (n) {
            case 0: {
                this.m11 = d;
                this.m12 = d2;
                this.m13 = d3;
                break;
            }
            case 1: {
                this.m21 = d;
                this.m22 = d2;
                this.m23 = d3;
                break;
            }
            case 2: {
                this.m31 = d;
                this.m32 = d2;
                this.m33 = d3;
            }
        }
    }

    public void setColumn(int n, Vector vector) {
        this.setColumn(n, vector.getX(), vector.getY(), vector.getZ());
    }

    public void setColumn(int n, double d, double d2, double d3) {
        switch (n) {
            case 0: {
                this.m11 = d;
                this.m21 = d2;
                this.m31 = d3;
                break;
            }
            case 1: {
                this.m12 = d;
                this.m22 = d2;
                this.m32 = d3;
                break;
            }
            case 2: {
                this.m13 = d;
                this.m23 = d2;
                this.m33 = d3;
            }
        }
    }

    public Vector getRow(int n) {
        return switch (n) {
            case 0 -> new Vector(this.m11, this.m12, this.m13);
            case 1 -> new Vector(this.m21, this.m22, this.m23);
            case 2 -> new Vector(this.m31, this.m32, this.m33);
            default -> throw new IllegalStateException("Unexpected value: " + n);
        };
    }

    public Vector getColumn(int n) {
        return switch (n) {
            case 0 -> new Vector(this.m11, this.m21, this.m31);
            case 1 -> new Vector(this.m12, this.m22, this.m32);
            case 2 -> new Vector(this.m13, this.m23, this.m33);
            default -> throw new IllegalStateException("Unexpected value: " + n);
        };
    }

    public EulerAngle toEulerAngle() {
        double d;
        double d2;
        double d3 = TMath.fastAsin(-TMath.clamp(this.m31, -1.0, 1.0));
        if (Math.abs(this.m31) < 0.9999999) {
            d2 = TMath.fastAtan2(this.m32, this.m33);
            d = TMath.fastAtan2(this.m21, this.m11);
        } else {
            d2 = 0.0;
            d = TMath.fastAtan2(-this.m12, this.m22);
        }
        return new EulerAngle(d2, -d3, -d);
    }

    public Quaternion toQuaternion() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = this.m11 + this.m22 + this.m33;
        if (d5 > 0.0) {
            double d6 = 0.5 * TMath.fastInvSqrt(d5 + 1.0);
            d4 = 0.25 / d6;
            d3 = -(this.m32 - this.m23) * d6;
            d2 = -(this.m13 - this.m31) * d6;
            d = -(this.m21 - this.m12) * d6;
        } else if (this.m11 > this.m22 && this.m11 > this.m33) {
            double d7 = 0.5 * TMath.fastInvSqrt(1.0 + this.m11 - this.m22 - this.m33);
            d4 = (this.m32 - this.m23) * d7;
            d3 = -0.25 / d7;
            d2 = -(this.m12 + this.m21) * d7;
            d = -(this.m13 + this.m31) * d7;
        } else if (this.m22 > this.m33) {
            double d8 = 0.5 * TMath.fastInvSqrt(1.0 + this.m22 - this.m11 - this.m33);
            d4 = -(this.m13 - this.m31) * d8;
            d3 = (this.m12 + this.m21) * d8;
            d2 = 0.25 / d8;
            d = (this.m23 + this.m32) * d8;
        } else {
            double d9 = 0.5 * TMath.fastInvSqrt(1.0 + this.m33 - this.m11 - this.m22);
            d4 = -(this.m21 - this.m12) * d9;
            d3 = (this.m13 + this.m31) * d9;
            d2 = (this.m23 + this.m32) * d9;
            d = 0.25 / d9;
        }
        return new Quaternion(d3, d2, d, d4);
    }

    public static Matrix3x3 multiply(Matrix3x3 matrix3x3, Matrix3x3 matrix3x32) {
        return new Matrix3x3(matrix3x3.m11 * matrix3x32.m11 + matrix3x3.m12 * matrix3x32.m21 + matrix3x3.m13 * matrix3x32.m31, matrix3x3.m11 * matrix3x32.m12 + matrix3x3.m12 * matrix3x32.m22 + matrix3x3.m13 * matrix3x32.m32, matrix3x3.m11 * matrix3x32.m13 + matrix3x3.m12 * matrix3x32.m23 + matrix3x3.m13 * matrix3x32.m33, matrix3x3.m21 * matrix3x32.m11 + matrix3x3.m22 * matrix3x32.m21 + matrix3x3.m23 * matrix3x32.m31, matrix3x3.m21 * matrix3x32.m12 + matrix3x3.m22 * matrix3x32.m22 + matrix3x3.m23 * matrix3x32.m32, matrix3x3.m21 * matrix3x32.m13 + matrix3x3.m22 * matrix3x32.m23 + matrix3x3.m23 * matrix3x32.m33, matrix3x3.m31 * matrix3x32.m11 + matrix3x3.m32 * matrix3x32.m21 + matrix3x3.m33 * matrix3x32.m31, matrix3x3.m31 * matrix3x32.m12 + matrix3x3.m32 * matrix3x32.m22 + matrix3x3.m33 * matrix3x32.m32, matrix3x3.m31 * matrix3x32.m13 + matrix3x3.m32 * matrix3x32.m23 + matrix3x3.m33 * matrix3x32.m33);
    }

    public static Matrix3x3 rotationAlign(Vector vector, Vector vector2) {
        Vector vector3 = vector.getCrossProduct(vector2);
        double d = vector.dot(vector2);
        double d2 = 1.0 / (1.0 + d);
        Matrix3x3 matrix3x3 = new Matrix3x3();
        matrix3x3.setRow(0, vector3.getX() * vector3.getX() * d2 + d, vector3.getY() * vector3.getX() * d2 - vector3.getZ(), vector3.getZ() * vector3.getX() * d2 + vector3.getY());
        matrix3x3.setRow(1, vector3.getX() * vector3.getY() * d2 + vector3.getZ(), vector3.getY() * vector3.getY() * d2 + d, vector3.getZ() * vector3.getY() * d2 - vector3.getX());
        matrix3x3.setRow(2, vector3.getX() * vector3.getZ() * d2 - vector3.getY(), vector3.getY() * vector3.getZ() * d2 + vector3.getX(), vector3.getZ() * vector3.getZ() * d2 + d);
        return matrix3x3;
    }

    public static Matrix3x3 fromEulerAngle(EulerAngle eulerAngle) {
        double d = eulerAngle.getX();
        double d2 = -eulerAngle.getY();
        double d3 = -eulerAngle.getZ();
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        double d6 = Math.cos(d2);
        double d7 = Math.sin(d2);
        double d8 = Math.cos(d3);
        double d9 = Math.sin(d3);
        double d10 = d4 * d8;
        double d11 = d4 * d9;
        double d12 = d5 * d8;
        double d13 = d5 * d9;
        double d14 = d6 * d8;
        double d15 = d12 * d7 - d11;
        double d16 = d10 * d7 + d13;
        double d17 = d6 * d9;
        double d18 = d13 * d7 + d10;
        double d19 = d11 * d7 - d12;
        double d20 = -d7;
        double d21 = d5 * d6;
        double d22 = d4 * d6;
        return new Matrix3x3(d14, d15, d16, d17, d18, d19, d20, d21, d22);
    }

    public static Matrix3x3 fromQuaternion(Quaternion quaternion) {
        double d = quaternion.getX();
        double d2 = quaternion.getY();
        double d3 = quaternion.getZ();
        double d4 = quaternion.getW();
        double d5 = d + d;
        double d6 = d2 + d2;
        double d7 = d3 + d3;
        double d8 = d * d5;
        double d9 = d * d6;
        double d10 = d * d7;
        double d11 = d2 * d6;
        double d12 = d2 * d7;
        double d13 = d3 * d7;
        double d14 = d4 * d5;
        double d15 = d4 * d6;
        double d16 = d4 * d7;
        double d17 = 1.0 - (d11 + d13);
        double d18 = d9 + d16;
        double d19 = d10 - d15;
        double d20 = d9 - d16;
        double d21 = 1.0 - (d8 + d13);
        double d22 = d12 + d14;
        double d23 = d10 + d15;
        double d24 = d12 - d14;
        double d25 = 1.0 - (d8 + d11);
        return new Matrix3x3(d17, d18, d19, d20, d21, d22, d23, d24, d25);
    }

    public double getM11() {
        return this.m11;
    }

    public double getM12() {
        return this.m12;
    }

    public double getM13() {
        return this.m13;
    }

    public double getM21() {
        return this.m21;
    }

    public double getM22() {
        return this.m22;
    }

    public double getM23() {
        return this.m23;
    }

    public double getM31() {
        return this.m31;
    }

    public double getM32() {
        return this.m32;
    }

    public double getM33() {
        return this.m33;
    }

    public void setM11(double d) {
        this.m11 = d;
    }

    public void setM12(double d) {
        this.m12 = d;
    }

    public void setM13(double d) {
        this.m13 = d;
    }

    public void setM21(double d) {
        this.m21 = d;
    }

    public void setM22(double d) {
        this.m22 = d;
    }

    public void setM23(double d) {
        this.m23 = d;
    }

    public void setM31(double d) {
        this.m31 = d;
    }

    public void setM32(double d) {
        this.m32 = d;
    }

    public void setM33(double d) {
        this.m33 = d;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Matrix3x3)) {
            return false;
        }
        Matrix3x3 matrix3x3 = (Matrix3x3)object;
        if (!matrix3x3.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getM11(), matrix3x3.getM11()) != 0) {
            return false;
        }
        if (Double.compare(this.getM12(), matrix3x3.getM12()) != 0) {
            return false;
        }
        if (Double.compare(this.getM13(), matrix3x3.getM13()) != 0) {
            return false;
        }
        if (Double.compare(this.getM21(), matrix3x3.getM21()) != 0) {
            return false;
        }
        if (Double.compare(this.getM22(), matrix3x3.getM22()) != 0) {
            return false;
        }
        if (Double.compare(this.getM23(), matrix3x3.getM23()) != 0) {
            return false;
        }
        if (Double.compare(this.getM31(), matrix3x3.getM31()) != 0) {
            return false;
        }
        if (Double.compare(this.getM32(), matrix3x3.getM32()) != 0) {
            return false;
        }
        return Double.compare(this.getM33(), matrix3x3.getM33()) == 0;
    }

    protected boolean canEqual(Object object) {
        return object instanceof Matrix3x3;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.getM11());
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = Double.doubleToLongBits(this.getM12());
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = Double.doubleToLongBits(this.getM13());
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = Double.doubleToLongBits(this.getM21());
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = Double.doubleToLongBits(this.getM22());
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        long l6 = Double.doubleToLongBits(this.getM23());
        n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
        long l7 = Double.doubleToLongBits(this.getM31());
        n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
        long l8 = Double.doubleToLongBits(this.getM32());
        n2 = n2 * 59 + (int)(l8 >>> 32 ^ l8);
        long l9 = Double.doubleToLongBits(this.getM33());
        n2 = n2 * 59 + (int)(l9 >>> 32 ^ l9);
        return n2;
    }

    public String toString() {
        return "Matrix3x3(m11=" + this.getM11() + ", m12=" + this.getM12() + ", m13=" + this.getM13() + ", m21=" + this.getM21() + ", m22=" + this.getM22() + ", m23=" + this.getM23() + ", m31=" + this.getM31() + ", m32=" + this.getM32() + ", m33=" + this.getM33() + ")";
    }

    public Matrix3x3(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m11 = d;
        this.m12 = d2;
        this.m13 = d3;
        this.m21 = d4;
        this.m22 = d5;
        this.m23 = d6;
        this.m31 = d7;
        this.m32 = d8;
        this.m33 = d9;
    }
}

