/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.math;

import com.ticxo.modelengine.api.utils.math.Offset;
import com.ticxo.modelengine.api.utils.math.Quaternion;
import com.ticxo.modelengine.api.utils.math.TMath;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class OrientedBoundingBox {
    private static final Vector GLOBAL_RIGHT = new Vector(1, 0, 0);
    private static final Vector GLOBAL_UP = new Vector(0, 1, 0);
    private static final Vector GLOBAL_FORWARD = new Vector(0, 0, 1);
    private final Vector origin;
    private final EulerAngle rotation;
    private final Vector right;
    private final Vector up;
    private final Vector forward;
    private final double halfX;
    private final double halfY;
    private final double halfZ;

    public OrientedBoundingBox(double d, double d2, double d3, double d4, double d5, double d6) {
        this.origin = new Vector((d4 + d) / 2.0, (d5 + d2) / 2.0, (d6 + d3) / 2.0);
        this.rotation = EulerAngle.ZERO;
        this.right = GLOBAL_RIGHT.clone();
        this.up = GLOBAL_UP.clone();
        this.forward = GLOBAL_FORWARD.clone();
        this.halfX = (d4 - d) / 2.0;
        this.halfY = (d5 - d2) / 2.0;
        this.halfZ = (d6 - d3) / 2.0;
    }

    public OrientedBoundingBox(Vector vector, Vector vector2, EulerAngle eulerAngle, float f) {
        this.origin = vector.clone();
        this.rotation = TMath.globalRotate(eulerAngle, TMath.makeAngle(0.0, f, 0.0));
        this.right = Offset.getRelativeLocation(this.rotation, GLOBAL_RIGHT.clone());
        this.up = Offset.getRelativeLocation(this.rotation, GLOBAL_UP.clone());
        this.forward = Offset.getRelativeLocation(this.rotation, GLOBAL_FORWARD.clone());
        this.halfX = vector2.getX() / 2.0;
        this.halfY = vector2.getY() / 2.0;
        this.halfZ = vector2.getZ() / 2.0;
    }

    public boolean intersects(BoundingBox boundingBox) {
        return this.intersects(new OrientedBoundingBox(boundingBox.getCenter(), new Vector(boundingBox.getWidthX(), boundingBox.getHeight(), boundingBox.getWidthZ()), EulerAngle.ZERO, 0.0f));
    }

    public boolean intersects(OrientedBoundingBox orientedBoundingBox) {
        Vector vector = new Vector(orientedBoundingBox.origin.getX() - this.origin.getX(), orientedBoundingBox.origin.getY() - this.origin.getY(), orientedBoundingBox.origin.getZ() - this.origin.getZ());
        for (int i = 0; i < 15; ++i) {
            double d;
            Vector vector2 = this.getL(i, orientedBoundingBox);
            double d2 = this.projectionOnAxis(vector, vector2);
            if (!(d2 > (d = this.projectionOnAxis(this.right.clone().multiply(this.halfX), vector2) + this.projectionOnAxis(this.up.clone().multiply(this.halfY), vector2) + this.projectionOnAxis(this.forward.clone().multiply(this.halfZ), vector2) + this.projectionOnAxis(orientedBoundingBox.right.clone().multiply(orientedBoundingBox.halfX), vector2) + this.projectionOnAxis(orientedBoundingBox.up.clone().multiply(orientedBoundingBox.halfY), vector2) + this.projectionOnAxis(orientedBoundingBox.forward.clone().multiply(orientedBoundingBox.halfZ), vector2)))) continue;
            return false;
        }
        return true;
    }

    public RayTraceResult rayTrace(@NotNull Vector vector, @NotNull Vector vector2, double d, Consumer<BoundingBox> consumer) {
        EulerAngle eulerAngle = Quaternion.fromEulerAngle(this.rotation).conjugate().toEulerAngle();
        Vector vector3 = Offset.getRelativeLocation(eulerAngle, vector.clone().subtract(this.origin)).add(this.origin);
        Vector vector4 = Offset.getRelativeLocation(eulerAngle, vector2.clone());
        BoundingBox boundingBox = BoundingBox.of((Vector)this.origin, (double)this.halfX, (double)this.halfY, (double)this.halfZ);
        consumer.accept((Object)boundingBox);
        RayTraceResult rayTraceResult = boundingBox.rayTrace(vector3, vector4, d);
        if (rayTraceResult == null) {
            return null;
        }
        Vector vector5 = Offset.getRelativeLocation(this.rotation, rayTraceResult.getHitPosition().subtract(this.origin)).add(this.origin);
        return new RayTraceResult(vector5, rayTraceResult.getHitBlockFace());
    }

    private double projectionOnAxis(Vector vector, Vector vector2) {
        return Math.abs(vector.dot(vector2));
    }

    private Vector getL(int n, OrientedBoundingBox orientedBoundingBox) {
        return switch (n) {
            case 0 -> this.right;
            case 1 -> this.up;
            case 2 -> this.forward;
            case 3 -> orientedBoundingBox.right;
            case 4 -> orientedBoundingBox.up;
            case 5 -> orientedBoundingBox.forward;
            case 6 -> this.right.getCrossProduct(orientedBoundingBox.right);
            case 7 -> this.right.getCrossProduct(orientedBoundingBox.up);
            case 8 -> this.right.getCrossProduct(orientedBoundingBox.forward);
            case 9 -> this.up.getCrossProduct(orientedBoundingBox.right);
            case 10 -> this.up.getCrossProduct(orientedBoundingBox.up);
            case 11 -> this.up.getCrossProduct(orientedBoundingBox.forward);
            case 12 -> this.forward.getCrossProduct(orientedBoundingBox.right);
            case 13 -> this.forward.getCrossProduct(orientedBoundingBox.up);
            case 14 -> this.forward.getCrossProduct(orientedBoundingBox.forward);
            default -> throw new IllegalStateException("Unexpected value: " + n);
        };
    }

    public void visualize(World world) {
        Vector vector = this.right.clone().multiply(this.halfX);
        Vector vector2 = this.up.clone().multiply(this.halfY);
        Vector vector3 = this.forward.clone().multiply(this.halfZ);
        Vector vector4 = vector.clone().multiply(-1);
        Vector vector5 = vector2.clone().multiply(-1);
        Vector vector6 = vector3.clone().multiply(-1);
        this.drawLine(vector, vector2, vector3, world, Color.ORANGE, this.halfZ * 2.0);
        this.drawLine(vector, vector5, vector3, world, Color.ORANGE, this.halfZ * 2.0);
        this.drawLine(vector4, vector2, vector3, world, Color.ORANGE, this.halfZ * 2.0);
        this.drawLine(vector4, vector5, vector3, world, Color.ORANGE, this.halfZ * 2.0);
        this.drawLine(vector2, vector3, vector, world, Color.GREEN, this.halfX * 2.0);
        this.drawLine(vector2, vector6, vector, world, Color.GREEN, this.halfX * 2.0);
        this.drawLine(vector5, vector3, vector, world, Color.GREEN, this.halfX * 2.0);
        this.drawLine(vector5, vector6, vector, world, Color.GREEN, this.halfX * 2.0);
        this.drawLine(vector3, vector, vector2, world, Color.AQUA, this.halfY * 2.0);
        this.drawLine(vector3, vector4, vector2, world, Color.AQUA, this.halfY * 2.0);
        this.drawLine(vector6, vector, vector2, world, Color.AQUA, this.halfY * 2.0);
        this.drawLine(vector6, vector4, vector2, world, Color.AQUA, this.halfY * 2.0);
    }

    private void drawLine(Vector vector, Vector vector2, Vector vector3, World world, Color color, double d) {
        Vector vector4 = vector.clone().add(vector2);
        Vector vector5 = vector4.clone().add(vector3);
        Vector vector6 = vector4.clone().subtract(vector3);
        for (double d2 = 0.0; d2 < d; d2 += 0.1) {
            Vector vector7 = TMath.lerp(vector5, vector6, d2 / d);
            world.spawnParticle(Particle.REDSTONE, this.origin.getX() + vector7.getX(), this.origin.getY() + vector7.getY(), this.origin.getZ() + vector7.getZ(), 1, (Object)new Particle.DustOptions(color, 0.2f));
        }
    }

    public String toString() {
        return "OrientedBoundingBox(origin=" + this.origin + ", rotation=" + this.rotation + ", right=" + this.right + ", up=" + this.up + ", forward=" + this.forward + ", halfX=" + this.halfX + ", halfY=" + this.halfY + ", halfZ=" + this.halfZ + ")";
    }
}

