/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.math;

import com.ticxo.modelengine.api.utils.math.TMath;
import org.bukkit.util.EulerAngle;

public class Quaternion {
    private double x;
    private double y;
    private double z;
    private double w;

    public Quaternion(Quaternion quaternion) {
        this(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public static Quaternion fromEulerAngle(EulerAngle eulerAngle) {
        return Quaternion.fromEulerAngle(eulerAngle.getX(), eulerAngle.getY(), eulerAngle.getZ());
    }

    public static Quaternion fromEulerAngleDegree(double d, double d2, double d3) {
        return Quaternion.fromEulerAngle(Math.toRadians(d), Math.toRadians(d2), Math.toRadians(d3));
    }

    public static Quaternion fromEulerAngle(double d, double d2, double d3) {
        double d4 = Math.cos(d * -0.5);
        double d5 = Math.cos(d2 * 0.5);
        double d6 = Math.cos(d3 * 0.5);
        double d7 = Math.sin(d * -0.5);
        double d8 = Math.sin(d2 * 0.5);
        double d9 = Math.sin(d3 * 0.5);
        return new Quaternion(d7 * d5 * d6 + d4 * d8 * d9, d4 * d8 * d6 - d7 * d5 * d9, d4 * d5 * d9 + d7 * d8 * d6, d4 * d5 * d6 - d7 * d8 * d9);
    }

    public static Quaternion globalRotate(Quaternion quaternion, Quaternion quaternion2) {
        return quaternion.altMul(quaternion2);
    }

    public static Quaternion localRotate(Quaternion quaternion, Quaternion quaternion2) {
        return Quaternion.globalRotate(quaternion2, quaternion);
    }

    public Quaternion add(Quaternion quaternion) {
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
        this.w += quaternion.w;
        return this;
    }

    public Quaternion mul(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        this.w *= d;
        return this;
    }

    public Quaternion mul(Quaternion quaternion) {
        double d = this.x;
        double d2 = this.y;
        double d3 = this.z;
        double d4 = this.w;
        double d5 = quaternion.x;
        double d6 = quaternion.y;
        double d7 = quaternion.z;
        double d8 = quaternion.w;
        this.x = d4 * d5 + d * d8 + d2 * d7 - d3 * d6;
        this.y = d4 * d6 - d * d7 + d2 * d8 + d3 * d5;
        this.z = d4 * d7 + d * d6 - d2 * d5 + d3 * d8;
        this.w = d4 * d8 - d * d5 - d2 * d6 - d3 * d7;
        return this;
    }

    public Quaternion normalize() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (d > 1.0E-6) {
            double d2 = TMath.fastInvSqrt(d);
            this.x *= d2;
            this.y *= d2;
            this.z *= d2;
            this.w *= d2;
        } else {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            this.w = 0.0;
        }
        return this;
    }

    public double dot(Quaternion quaternion) {
        return this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
    }

    public Quaternion altAdd(Quaternion quaternion) {
        Quaternion quaternion2 = this.copy();
        quaternion2.add(quaternion);
        return quaternion2;
    }

    public Quaternion altMul(Quaternion quaternion) {
        Quaternion quaternion2 = this.copy();
        quaternion2.mul(quaternion);
        return quaternion2;
    }

    public Quaternion altMul(double d) {
        Quaternion quaternion = this.copy();
        quaternion.mul(d);
        return quaternion;
    }

    public Quaternion conjugate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
        return this;
    }

    public Quaternion altConjugate() {
        Quaternion quaternion = this.copy();
        return quaternion.conjugate();
    }

    public Quaternion copy() {
        return new Quaternion(this);
    }

    public EulerAngle toEulerAngle() {
        double d;
        double d2;
        double d3 = this.x + this.x;
        double d4 = this.y + this.y;
        double d5 = this.z + this.z;
        double d6 = this.x * d3;
        double d7 = this.x * d4;
        double d8 = this.x * d5;
        double d9 = this.y * d4;
        double d10 = this.y * d5;
        double d11 = this.z * d5;
        double d12 = this.w * d3;
        double d13 = this.w * d4;
        double d14 = this.w * d5;
        double d15 = 1.0 - (d9 + d11);
        double d16 = d7 + d14;
        double d17 = d7 - d14;
        double d18 = 1.0 - (d6 + d11);
        double d19 = d8 + d13;
        double d20 = d10 - d12;
        double d21 = 1.0 - (d6 + d9);
        double d22 = TMath.fastAsin(-TMath.clamp(d19, -1.0, 1.0));
        if (Math.abs(d19) < 0.9999999) {
            d2 = TMath.fastAtan2(d20, d21);
            d = TMath.fastAtan2(d17, d15);
        } else {
            d2 = 0.0;
            d = TMath.fastAtan2(-d16, d18);
        }
        return new EulerAngle(d2, -d22, -d);
    }

    public Quaternion(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public String toString() {
        return "Quaternion(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", w=" + this.getW() + ")";
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public void setW(double d) {
        this.w = d;
    }
}

