/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.math;

import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.math.Quaternion;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class TMath {
    public static final double TAU = Math.PI * 2;
    public static final double PI_2 = 1.5707963267948966;
    public static final double PI_4 = 0.7853981633974483;
    public static final double EPSILON = 1.0E-5;
    protected static SlerpMode slerpMode = SlerpMode.SLERP;
    protected static double movementResolution = 0.001;

    public static void updateConfigs() {
        slerpMode = ConfigProperty.SLERP_MODE.getSlerpMode();
        movementResolution = ConfigProperty.MOVE_RESOLUTION.getDouble();
    }

    public static double clamp(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), d3);
    }

    public static float clamp(float f, float f2, float f3) {
        return Math.min(Math.max(f, f2), f3);
    }

    public static double tryParse(String string, double d) {
        if (string == null) {
            return d;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static boolean isBoundingBoxWithinDistance(@NotNull Vector vector, @NotNull Vector vector2, BoundingBox boundingBox, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = vector.getX();
        double d9 = vector.getY();
        double d10 = vector.getZ();
        Vector vector3 = vector2.clone();
        if (vector3.getX() == 0.0) {
            vector3.setX(0);
        }
        if (vector3.getY() == 0.0) {
            vector3.setY(0);
        }
        if (vector3.getZ() == 0.0) {
            vector3.setZ(0);
        }
        vector3.normalize();
        double d11 = vector3.getX();
        double d12 = vector3.getY();
        double d13 = vector3.getZ();
        double d14 = 1.0 / d11;
        double d15 = 1.0 / d12;
        double d16 = 1.0 / d13;
        if (d11 >= 0.0) {
            d7 = (boundingBox.getMinX() - d8) * d14;
            d6 = (boundingBox.getMaxX() - d8) * d14;
        } else {
            d7 = (boundingBox.getMaxX() - d8) * d14;
            d6 = (boundingBox.getMinX() - d8) * d14;
        }
        if (d12 >= 0.0) {
            d5 = (boundingBox.getMinY() - d9) * d15;
            d4 = (boundingBox.getMaxY() - d9) * d15;
        } else {
            d5 = (boundingBox.getMaxY() - d9) * d15;
            d4 = (boundingBox.getMinY() - d9) * d15;
        }
        if (d7 > d4 || d6 < d5) {
            return false;
        }
        if (d5 > d7) {
            d7 = d5;
        }
        if (d4 < d6) {
            d6 = d4;
        }
        if (d13 >= 0.0) {
            d3 = (boundingBox.getMinZ() - d10) * d16;
            d2 = (boundingBox.getMaxZ() - d10) * d16;
        } else {
            d3 = (boundingBox.getMaxZ() - d10) * d16;
            d2 = (boundingBox.getMinZ() - d10) * d16;
        }
        if (d7 > d2 || d6 < d3) {
            return false;
        }
        if (d3 > d7) {
            d7 = d3;
        }
        if (d2 < d6) {
            d6 = d2;
        }
        if (d6 < 0.0) {
            return false;
        }
        return !(d7 > d);
    }

    public static boolean isSimilar(Vector vector, Vector vector2) {
        return Math.abs(vector2.getX() - vector.getX()) < movementResolution && Math.abs(vector2.getY() - vector.getY()) < movementResolution && Math.abs(vector2.getZ() - vector.getZ()) < movementResolution;
    }

    public static EulerAngle makeAngle(double d, double d2, double d3) {
        return new EulerAngle(Math.toRadians(d), Math.toRadians(d2), Math.toRadians(d3));
    }

    public static EulerAngle add(EulerAngle eulerAngle, EulerAngle eulerAngle2) {
        return eulerAngle.add(eulerAngle2.getX(), eulerAngle2.getY(), eulerAngle2.getZ());
    }

    public static EulerAngle globalRotate(EulerAngle eulerAngle, EulerAngle eulerAngle2) {
        return Quaternion.globalRotate(Quaternion.fromEulerAngle(eulerAngle), Quaternion.fromEulerAngle(eulerAngle2)).toEulerAngle();
    }

    public static EulerAngle localRotate(EulerAngle eulerAngle, EulerAngle eulerAngle2) {
        return TMath.globalRotate(eulerAngle2, eulerAngle);
    }

    public static float wrapRadian(float f) {
        if ((double)(f = (float)((double)f % (Math.PI * 2))) < -Math.PI) {
            f = (float)((double)f + Math.PI * 2);
        }
        if ((double)f > Math.PI) {
            f = (float)((double)f - Math.PI * 2);
        }
        return f;
    }

    public static float wrapDegree(float f) {
        if ((f %= 360.0f) < -180.0f) {
            f += 360.0f;
        }
        if (f > 180.0f) {
            f -= 360.0f;
        }
        return f;
    }

    public static float radianDifference(float f, float f2) {
        return TMath.wrapRadian(f2 - f);
    }

    public static float degreeDifference(float f, float f2) {
        return TMath.wrapDegree(f2 - f);
    }

    public static float rotateIfNecessary(float f, float f2, float f3, float f4) {
        float f5 = TMath.degreeDifference(f, f2);
        float f6 = TMath.clamp(f5, f3, f4);
        return f2 - f6;
    }

    public static byte rotToByte(float f) {
        return (byte)(f * 256.0f / 360.0f);
    }

    public static float byteToRot(byte by) {
        return (float)by / 256.0f * 360.0f;
    }

    public static double lerp(double d, double d2, double d3) {
        return (1.0 - d3) * d + d3 * d2;
    }

    public static double lerp(double d, double d2, double d3, double d4) {
        return d3 * d + d4 * d2;
    }

    public static double rotLerp(double d, double d2, double d3) {
        return d + (double)TMath.degreeDifference((float)d, (float)d2) * d3;
    }

    public static float rotLerp(float f, float f2, double d) {
        return (float)((double)f + (double)TMath.degreeDifference(f, f2) * d);
    }

    public static double smoothLerp(double d, double d2, double d3, double d4, double d5) {
        double d6 = 0.0;
        double d7 = 1.0;
        double d8 = 2.0;
        double d9 = 3.0;
        d5 = (d8 - d7) * d5 + d7;
        double d10 = TMath.lerp(d, d2, (d7 - d5) / (d7 - d6), (d5 - d6) / (d7 - d6));
        double d11 = TMath.lerp(d2, d3, (d8 - d5) / (d8 - d7), (d5 - d7) / (d8 - d7));
        double d12 = TMath.lerp(d3, d4, (d9 - d5) / (d9 - d8), (d5 - d8) / (d9 - d8));
        double d13 = TMath.lerp(d10, d11, (d8 - d5) / (d8 - d6), (d5 - d6) / (d8 - d6));
        double d14 = TMath.lerp(d11, d12, (d9 - d5) / (d9 - d7), (d5 - d7) / (d9 - d7));
        return TMath.lerp(d13, d14, (d8 - d5) / (d8 - d7), (d5 - d7) / (d8 - d7));
    }

    public static Vector lerp(Vector vector, Vector vector2, double d) {
        return new Vector(TMath.lerp(vector.getX(), vector2.getX(), d), TMath.lerp(vector.getY(), vector2.getY(), d), TMath.lerp(vector.getZ(), vector2.getZ(), d));
    }

    public static Vector lerp(Vector vector, Vector vector2, double d, double d2) {
        return new Vector(TMath.lerp(vector.getX(), vector2.getX(), d, d2), TMath.lerp(vector.getY(), vector2.getY(), d, d2), TMath.lerp(vector.getZ(), vector2.getZ(), d, d2));
    }

    public static Vector smoothLerp(Vector vector, Vector vector2, Vector vector3, Vector vector4, double d) {
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 2.0;
        double d5 = 3.0;
        d = (d4 - d3) * d + d3;
        Vector vector5 = TMath.lerp(vector, vector2, (d3 - d) / (d3 - d2), (d - d2) / (d3 - d2));
        Vector vector6 = TMath.lerp(vector2, vector3, (d4 - d) / (d4 - d3), (d - d3) / (d4 - d3));
        Vector vector7 = TMath.lerp(vector3, vector4, (d5 - d) / (d5 - d4), (d - d4) / (d5 - d4));
        Vector vector8 = TMath.lerp(vector5, vector6, (d4 - d) / (d4 - d2), (d - d2) / (d4 - d2));
        Vector vector9 = TMath.lerp(vector6, vector7, (d5 - d) / (d5 - d3), (d - d3) / (d5 - d3));
        return TMath.lerp(vector8, vector9, (d4 - d) / (d4 - d3), (d - d3) / (d4 - d3));
    }

    public static EulerAngle lerp(EulerAngle eulerAngle, EulerAngle eulerAngle2, double d) {
        return new EulerAngle(TMath.lerp(eulerAngle.getX(), eulerAngle2.getX(), d), TMath.lerp(eulerAngle.getY(), eulerAngle2.getY(), d), TMath.lerp(eulerAngle.getZ(), eulerAngle2.getZ(), d));
    }

    public static EulerAngle lerp(EulerAngle eulerAngle, EulerAngle eulerAngle2, double d, double d2) {
        return new EulerAngle(TMath.lerp(eulerAngle.getX(), eulerAngle2.getX(), d, d2), TMath.lerp(eulerAngle.getY(), eulerAngle2.getY(), d, d2), TMath.lerp(eulerAngle.getZ(), eulerAngle2.getZ(), d, d2));
    }

    public static EulerAngle smoothLerp(EulerAngle eulerAngle, EulerAngle eulerAngle2, EulerAngle eulerAngle3, EulerAngle eulerAngle4, double d) {
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 2.0;
        double d5 = 3.0;
        d = (d4 - d3) * d + d3;
        EulerAngle eulerAngle5 = TMath.lerp(eulerAngle, eulerAngle2, (d3 - d) / (d3 - d2), (d - d2) / (d3 - d2));
        EulerAngle eulerAngle6 = TMath.lerp(eulerAngle2, eulerAngle3, (d4 - d) / (d4 - d3), (d - d3) / (d4 - d3));
        EulerAngle eulerAngle7 = TMath.lerp(eulerAngle3, eulerAngle4, (d5 - d) / (d5 - d4), (d - d4) / (d5 - d4));
        EulerAngle eulerAngle8 = TMath.lerp(eulerAngle5, eulerAngle6, (d4 - d) / (d4 - d2), (d - d2) / (d4 - d2));
        EulerAngle eulerAngle9 = TMath.lerp(eulerAngle6, eulerAngle7, (d5 - d) / (d5 - d3), (d - d3) / (d5 - d3));
        return TMath.lerp(eulerAngle8, eulerAngle9, (d4 - d) / (d4 - d3), (d - d3) / (d4 - d3));
    }

    public static EulerAngle slerp(EulerAngle eulerAngle, EulerAngle eulerAngle2, double d) {
        return TMath.slerp(Quaternion.fromEulerAngle(eulerAngle), Quaternion.fromEulerAngle(eulerAngle2), d).toEulerAngle();
    }

    public static Quaternion lerp(Quaternion quaternion, Quaternion quaternion2, double d, double d2) {
        return new Quaternion(TMath.lerp(quaternion.getX(), quaternion2.getX(), d, d2), TMath.lerp(quaternion.getY(), quaternion2.getY(), d, d2), TMath.lerp(quaternion.getZ(), quaternion2.getZ(), d, d2), TMath.lerp(quaternion.getW(), quaternion2.getW(), d, d2)).normalize();
    }

    public static Quaternion onlerp(Quaternion quaternion, Quaternion quaternion2, double d) {
        float f = (float)quaternion.dot(quaternion2);
        d = TMath.aprox(f, (float)d);
        return TMath.lerp(quaternion, quaternion2, 1.0 - d, f > 0.0f ? d : -d);
    }

    public static Quaternion smoothOnlerp(Quaternion quaternion, Quaternion quaternion2, Quaternion quaternion3, Quaternion quaternion4, double d) {
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 2.0;
        double d5 = 3.0;
        float f = (float)quaternion2.dot(quaternion3);
        d = TMath.aprox(f, (float)((d4 - d3) * d + d3));
        Quaternion quaternion5 = TMath.lerp(quaternion, quaternion2, (d3 - d) / (d3 - d2), (d - d2) / (d3 - d2));
        Quaternion quaternion6 = TMath.lerp(quaternion2, quaternion3, (d4 - d) / (d4 - d3), (d - d3) / (d4 - d3));
        Quaternion quaternion7 = TMath.lerp(quaternion3, quaternion4, (d5 - d) / (d5 - d4), (d - d4) / (d5 - d4));
        Quaternion quaternion8 = TMath.lerp(quaternion5, quaternion6, (d4 - d) / (d4 - d2), (d - d2) / (d4 - d2));
        Quaternion quaternion9 = TMath.lerp(quaternion6, quaternion7, (d5 - d) / (d5 - d3), (d - d3) / (d5 - d3));
        return TMath.lerp(quaternion8, quaternion9, (d4 - d) / (d4 - d3), (d - d3) / (d4 - d3));
    }

    private static float aprox(float f, float f2) {
        float f3 = Math.abs(f);
        float f4 = 1.0904f + f3 * (-3.2452f + f3 * (3.55645f - f3 * 1.43519f));
        float f5 = 0.848013f + f3 * (-1.06021f + f3 * 0.215638f);
        float f6 = f4 * (f2 - 0.5f) * (f2 - 0.5f) + f5;
        return f2 + f2 * (f2 - 0.5f) * (f2 - 1.0f) * f6;
    }

    public static Quaternion tSlerp(Quaternion quaternion, Quaternion quaternion2, double d) {
        return TMath.tSlerp(quaternion, quaternion2, 1.0 - d, d);
    }

    public static Quaternion tSlerp(Quaternion quaternion, Quaternion quaternion2, double d, double d2) {
        double d3 = quaternion.dot(quaternion2);
        double d4 = Math.abs(d3);
        if (d4 <= 0.9995) {
            double d5 = Math.acos(d4);
            double d6 = Math.sin(d5);
            d = Math.sin(d5 * d) / d6;
            d2 = Math.sin(d5 * d2) / d6;
            if (d3 < 0.0) {
                d *= -1.0;
            }
        }
        return quaternion.altMul(d).add(quaternion2.altMul(d2)).normalize();
    }

    public static Quaternion smoothTSlerp(Quaternion quaternion, Quaternion quaternion2, Quaternion quaternion3, Quaternion quaternion4, double d) {
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 2.0;
        double d5 = 3.0;
        d = (d4 - d3) * d + d3;
        Quaternion quaternion5 = TMath.tSlerp(quaternion, quaternion2, (d3 - d) / (d3 - d2), (d - d2) / (d3 - d2));
        Quaternion quaternion6 = TMath.tSlerp(quaternion2, quaternion3, (d4 - d) / (d4 - d3), (d - d3) / (d4 - d3));
        Quaternion quaternion7 = TMath.tSlerp(quaternion3, quaternion4, (d5 - d) / (d5 - d4), (d - d4) / (d5 - d4));
        Quaternion quaternion8 = TMath.tSlerp(quaternion5, quaternion6, (d4 - d) / (d4 - d2), (d - d2) / (d4 - d2));
        Quaternion quaternion9 = TMath.tSlerp(quaternion6, quaternion7, (d5 - d) / (d5 - d3), (d - d3) / (d5 - d3));
        return TMath.tSlerp(quaternion8, quaternion9, (d4 - d) / (d4 - d3), (d - d3) / (d4 - d3));
    }

    public static Quaternion slerp(Quaternion quaternion, Quaternion quaternion2, double d) {
        return switch (slerpMode) {
            case SlerpMode.SLERP -> TMath.tSlerp(quaternion, quaternion2, d);
            case SlerpMode.ONLERP -> TMath.onlerp(quaternion, quaternion2, d);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static EulerAngle smoothSlerp(EulerAngle eulerAngle, EulerAngle eulerAngle2, EulerAngle eulerAngle3, EulerAngle eulerAngle4, double d) {
        return switch (slerpMode) {
            case SlerpMode.SLERP -> TMath.smoothTSlerp(Quaternion.fromEulerAngle(eulerAngle), Quaternion.fromEulerAngle(eulerAngle2), Quaternion.fromEulerAngle(eulerAngle3), Quaternion.fromEulerAngle(eulerAngle4), d).toEulerAngle();
            case SlerpMode.ONLERP -> TMath.smoothOnlerp(Quaternion.fromEulerAngle(eulerAngle), Quaternion.fromEulerAngle(eulerAngle2), Quaternion.fromEulerAngle(eulerAngle3), Quaternion.fromEulerAngle(eulerAngle4), d).toEulerAngle();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static String toString(EulerAngle eulerAngle) {
        return String.format("[%s, %s, %s]", Math.toDegrees(eulerAngle.getX()), Math.toDegrees(eulerAngle.getY()), Math.toDegrees(eulerAngle.getZ()));
    }

    public static float fastSqrt(float f) {
        return f * TMath.fastInvSqrt(f);
    }

    public static double fastSqrt(double d) {
        return d * TMath.fastInvSqrt(d);
    }

    public static float fastInvSqrt(float f) {
        float f2 = 0.5f * f;
        int n = Float.floatToIntBits(f);
        n = 1597463007 - (n >> 1);
        f = Float.intBitsToFloat(n);
        f = (float)((double)f * (1.5 - (double)(f2 * f * f)));
        return f;
    }

    public static double fastInvSqrt(double d) {
        double d2 = 0.5 * d;
        long l = Double.doubleToRawLongBits(d);
        l = 6910469410427058090L - (l >> 1);
        d = Double.longBitsToDouble(l);
        d *= 1.5 - d2 * d * d;
        return d;
    }

    public static double fastAsin(double d) {
        return TMath.fastAtan(d * TMath.fastInvSqrt(1.0 - d * d));
    }

    public static double fastAtan(double d) {
        if (d < -1.0 || d > 1.0) {
            return Math.atan(d);
        }
        return TMath.atanScalarAprox(d);
    }

    public static double fastAtan2(double d, double d2) {
        boolean bl;
        boolean bl2;
        double d3 = d * d + d2 * d2;
        if (Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d2 == 0.0) {
            return d == 0.0 ? Double.NaN : (d < 0.0 ? -1.5707963267948966 : 1.5707963267948966);
        }
        boolean bl3 = bl2 = d < 0.0;
        if (bl2) {
            d = -d;
        }
        boolean bl4 = bl = d2 < 0.0;
        if (bl) {
            d2 = -d2;
        }
        boolean bl5 = d > d2;
        double d4 = TMath.atanScalarAprox(bl5 ? d2 / d : d / d2);
        if (bl5) {
            d4 = 1.5707963267948966 - d4;
        }
        if (bl) {
            d4 = Math.PI - d4;
        }
        if (bl2) {
            d4 = -d4;
        }
        return d4;
    }

    private static double atanScalarAprox(double d) {
        double d2 = 0.99997726;
        double d3 = -0.33262347;
        double d4 = 0.19354346;
        double d5 = -0.11643287;
        double d6 = 0.05265332;
        double d7 = -0.0117212;
        double d8 = d * d;
        return d * (d2 + d8 * (d3 + d8 * (d4 + d8 * (d5 + d8 * (d6 + d8 * d7)))));
    }

    public static double fastLength(double d, double d2, double d3) {
        double d4 = d * d + d2 * d2 + d3 * d3;
        return d4 * TMath.fastInvSqrt(d4);
    }

    public static Vector fastNormalize(Vector vector) {
        return vector.multiply(TMath.fastInvSqrt(vector.lengthSquared()));
    }

    public static int biasRound(double d, double d2) {
        return (int)(d % 1.0 < d2 ? Math.floor(d) : Math.ceil(d));
    }

    public static enum SlerpMode {
        SLERP,
        ONLERP;


        public static SlerpMode get(String string) {
            try {
                return SlerpMode.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return SLERP;
            }
        }
    }
}

