/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.citizens;

import com.ticxo.modelengine.ModelEngine;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.events.ModelRegistrationEvent;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.utils.data.EntityData;
import com.ticxo.modelengine.citizens.CitizensEntity;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import org.jetbrains.annotations.Nullable;

@TraitName(value="meg_model")
public class ModelTrait
extends Trait {
    protected static final String TRAIT_NAME = "meg_model";
    protected static final String KEY_NAME = "model_data";
    private boolean taskQueued = false;
    private EntityData data;
    private ModeledEntity modeledEntity;
    private int lastTicked;

    public ModelTrait() {
        super(TRAIT_NAME);
    }

    public void load(DataKey dataKey) {
        String string = dataKey.getString(KEY_NAME, null);
        if (string == null) {
            this.data = new EntityData();
            return;
        }
        this.data = (EntityData)ModelEngine.gson.fromJson(string, EntityData.class);
    }

    public void save(DataKey dataKey) {
        if (this.data == null) {
            this.data = new EntityData();
        }
        if (this.modeledEntity == null) {
            return;
        }
        this.data.save(this.modeledEntity);
        dataKey.setString(KEY_NAME, ModelEngine.gson.toJson((Object)this.data));
    }

    public void onAttach() {
        if (this.npc.getEntity() != null) {
            this.onInit();
        }
    }

    public void onCopy() {
        this.onInit();
    }

    public void onDespawn() {
        if (this.modeledEntity == null) {
            return;
        }
        if (this.data == null) {
            this.data = new EntityData();
        }
        this.data.save(this.modeledEntity);
        this.modeledEntity.destroy();
        this.modeledEntity = null;
    }

    public void onPreSpawn() {
        super.onPreSpawn();
    }

    public void onRemove() {
        if (this.modeledEntity == null) {
            return;
        }
        this.modeledEntity.setBaseEntityVisible(true);
        this.modeledEntity.destroy();
    }

    public void onSpawn() {
        this.onInit();
    }

    public void run() {
        Hitbox hitbox;
        if (this.npc.getEntity() == null || this.data == null || this.modeledEntity == null) {
            return;
        }
        int n = this.npc.getEntity().getTicksLived();
        if (n - this.lastTicked == 1 && (hitbox = this.data.getHitbox()) != null) {
            double d = this.npc.getEntity().getBoundingBox().getWidthX();
            double d2 = this.npc.getEntity().getBoundingBox().getHeight();
            if (hitbox.getHeight() != d2 || hitbox.getMaxWidth() != d) {
                this.modeledEntity.getBase().setHitbox(hitbox);
            }
        }
        this.lastTicked = n;
    }

    private void onInit() {
        if (!ModelEngineAPI.api.getGenerator().isInitialized()) {
            if (!this.taskQueued) {
                this.taskQueued = true;
                ModelEngineAPI.api.getGenerator().queueTask(ModelRegistrationEvent.Phase.POST, this::onInit);
            }
            return;
        }
        this.taskQueued = false;
        if (this.data != null && this.npc.getEntity() != null) {
            this.getModeledEntity();
            if (this.modeledEntity != null) {
                this.data.load(this.modeledEntity);
            }
            this.lastTicked = this.npc.getEntity().getTicksLived();
        }
    }

    @Nullable
    public ModeledEntity getModeledEntity() {
        if (this.modeledEntity != null) {
            return this.modeledEntity;
        }
        this.modeledEntity = ModelEngineAPI.getModeledEntity(this.npc.getUniqueId());
        if (this.modeledEntity == null && this.npc.getEntity() != null) {
            this.modeledEntity = ModelEngineAPI.createModeledEntity(new CitizensEntity(this.npc));
        }
        return this.modeledEntity;
    }
}

