/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.command.MECommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DisguiseCommand
extends AbstractCommand {
    public DisguiseCommand(AbstractCommand abstractCommand) {
        super(abstractCommand);
    }

    @Override
    public boolean onCommand(CommandSender commandSender, String[] stringArray) {
        Object object;
        RangeManager rangeManager;
        Player player = (Player)commandSender;
        if (stringArray.length < 1) {
            return false;
        }
        ModelBlueprint modelBlueprint = ModelEngineAPI.getBlueprint(stringArray[0]);
        if (modelBlueprint == null) {
            return false;
        }
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(player.getUniqueId());
        if (modeledEntity == null) {
            modeledEntity = ModelEngineAPI.createModeledEntity(player);
            modeledEntity.setBaseEntityVisible(false);
            ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(player, true);
        }
        if ((rangeManager = modeledEntity.getRangeManager()) instanceof RangeManager.Disguise) {
            object = (RangeManager.Disguise)((Object)rangeManager);
            object.setIncludeSelf(stringArray.length < 2 || Boolean.parseBoolean(stringArray[1]));
        }
        if (modeledEntity.getModel(stringArray[0]) == null) {
            object = ModelEngineAPI.createActiveModel(modelBlueprint);
            modeledEntity.addModel((ActiveModel)object, false);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (stringArray.length) {
            case 1: {
                MECommand.getModelIdTabComplete(arrayList, stringArray[0]);
                break;
            }
            case 2: {
                String string = stringArray[1].toLowerCase(Locale.ENGLISH);
                if ("true".startsWith(string)) {
                    arrayList.add("true");
                }
                if (!"false".startsWith(string)) break;
                arrayList.add("false");
            }
        }
        return arrayList;
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.disguise";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "disguise";
    }
}

