/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.ticxo.modelengine.api.animation.AnimationHandler;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.command.MECommand;
import com.ticxo.modelengine.command.sub.SelectCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StateCommand
extends AbstractCommand {
    public StateCommand(AbstractCommand abstractCommand) {
        super(abstractCommand);
        this.addSubCommands(new AddStateCommand(this));
        this.addSubCommands(new RemoveStateCommand(this));
        this.addSubCommands(new ListStateCommand(this));
    }

    @Override
    public boolean onCommand(CommandSender commandSender, String[] stringArray) {
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.state";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "state";
    }

    static class AddStateCommand
    extends AbstractCommand {
        public AddStateCommand(AbstractCommand abstractCommand) {
            super(abstractCommand);
        }

        @Override
        public boolean onCommand(CommandSender commandSender, String[] stringArray) {
            if (stringArray.length < 2) {
                return false;
            }
            Player player = (Player)commandSender;
            ModeledEntity modeledEntity = SelectCommand.SELECTED.get(player);
            if (modeledEntity == null) {
                return false;
            }
            ActiveModel activeModel = modeledEntity.getModel(stringArray[0]);
            if (activeModel == null) {
                return false;
            }
            if (!activeModel.getBlueprint().getAnimations().containsKey(stringArray[1])) {
                return false;
            }
            AnimationHandler animationHandler = activeModel.getAnimationHandler();
            animationHandler.playAnimation(stringArray[1], 0.0, 0.0, 1.0, true);
            return true;
        }

        @Override
        public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
            Player player = (Player)commandSender;
            ModeledEntity modeledEntity = SelectCommand.SELECTED.get(player);
            if (modeledEntity == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            switch (stringArray.length) {
                case 1: {
                    MECommand.getModelIdTabComplete(arrayList, stringArray[0], modeledEntity);
                    break;
                }
                case 2: {
                    ActiveModel activeModel = modeledEntity.getModel(stringArray[0]);
                    if (activeModel == null) {
                        return arrayList;
                    }
                    MECommand.getStateTabComplete(arrayList, stringArray[1], activeModel.getBlueprint());
                }
            }
            return arrayList;
        }

        @Override
        public String getPermissionNode() {
            return "modelengine.command.state.add";
        }

        @Override
        public boolean isConsoleFriendly() {
            return true;
        }

        @Override
        public String getName() {
            return "add";
        }
    }

    static class RemoveStateCommand
    extends AbstractCommand {
        public RemoveStateCommand(AbstractCommand abstractCommand) {
            super(abstractCommand);
        }

        @Override
        public boolean onCommand(CommandSender commandSender, String[] stringArray) {
            if (stringArray.length < 2) {
                return false;
            }
            Player player = (Player)commandSender;
            ModeledEntity modeledEntity = SelectCommand.SELECTED.get(player);
            if (modeledEntity == null) {
                return false;
            }
            ActiveModel activeModel = modeledEntity.getModel(stringArray[0]);
            if (activeModel == null) {
                return false;
            }
            AnimationHandler animationHandler = activeModel.getAnimationHandler();
            animationHandler.stopAnimation(stringArray[1]);
            return true;
        }

        @Override
        public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
            Player player = (Player)commandSender;
            ModeledEntity modeledEntity = SelectCommand.SELECTED.get(player);
            if (modeledEntity == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            switch (stringArray.length) {
                case 1: {
                    MECommand.getModelIdTabComplete(arrayList, stringArray[0], modeledEntity);
                    break;
                }
                case 2: {
                    ActiveModel activeModel = modeledEntity.getModel(stringArray[0]);
                    if (activeModel == null) {
                        return arrayList;
                    }
                    MECommand.getStateTabComplete(arrayList, stringArray[1], activeModel);
                }
            }
            return arrayList;
        }

        @Override
        public String getPermissionNode() {
            return "modelengine.command.state.remove";
        }

        @Override
        public boolean isConsoleFriendly() {
            return true;
        }

        @Override
        public String getName() {
            return "remove";
        }
    }

    static class ListStateCommand
    extends AbstractCommand {
        public ListStateCommand(AbstractCommand abstractCommand) {
            super(abstractCommand);
        }

        @Override
        public boolean onCommand(CommandSender commandSender, String[] stringArray) {
            Player player = (Player)commandSender;
            ModeledEntity modeledEntity = SelectCommand.SELECTED.get(player);
            if (modeledEntity == null) {
                return false;
            }
            StringBuilder stringBuilder = new StringBuilder();
            switch (stringArray.length) {
                case 0: {
                    for (String string : modeledEntity.getModels().keySet()) {
                        ActiveModel activeModel = modeledEntity.getModel(string);
                        stringBuilder.append(string).append(": ");
                        for (IAnimationProperty iAnimationProperty : activeModel.getAnimationHandler().getAnimations()) {
                            stringBuilder.append(iAnimationProperty.getName()).append(", ");
                        }
                        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length()).append("\n");
                    }
                    break;
                }
                case 1: {
                    ActiveModel activeModel = modeledEntity.getModel(stringArray[0]);
                    if (activeModel == null) {
                        return false;
                    }
                    stringBuilder.append(stringArray[0]).append(": ");
                    for (IAnimationProperty iAnimationProperty : activeModel.getAnimationHandler().getAnimations()) {
                        stringBuilder.append(iAnimationProperty.getName()).append(", ");
                    }
                    stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
                }
            }
            player.sendMessage(stringBuilder.toString());
            return true;
        }

        @Override
        public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
            Player player = (Player)commandSender;
            ModeledEntity modeledEntity = SelectCommand.SELECTED.get(player);
            if (modeledEntity == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray.length == 1) {
                MECommand.getModelIdTabComplete(arrayList, stringArray[0], modeledEntity);
            }
            return arrayList;
        }

        @Override
        public String getPermissionNode() {
            return "modelengine.command.state.list";
        }

        @Override
        public boolean isConsoleFriendly() {
            return true;
        }

        @Override
        public String getName() {
            return "list";
        }
    }
}

