/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.command.MECommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class SummonCommand
extends AbstractCommand {
    public SummonCommand(AbstractCommand abstractCommand) {
        super(abstractCommand);
    }

    @Override
    public boolean onCommand(CommandSender commandSender, String[] stringArray) {
        if (stringArray.length < 1) {
            return false;
        }
        EntityType entityType = EntityType.PIG;
        if (stringArray.length >= 2) {
            try {
                entityType = EntityType.valueOf((String)stringArray[1].toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Player player = (Player)commandSender;
        Location location = player.getLocation();
        Entity entity = player.getWorld().spawnEntity(location, entityType);
        ModelBlueprint modelBlueprint = ModelEngineAPI.getBlueprint(stringArray[0]);
        if (modelBlueprint == null) {
            return false;
        }
        ModeledEntity modeledEntity = ModelEngineAPI.createModeledEntity(entity);
        modeledEntity.setBaseEntityVisible(false);
        ActiveModel activeModel = ModelEngineAPI.createActiveModel(modelBlueprint);
        modeledEntity.addModel(activeModel, true);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (stringArray.length) {
            case 1: {
                MECommand.getModelIdTabComplete(arrayList, stringArray[0]);
                break;
            }
            case 2: {
                String string = stringArray[1];
                for (EntityType entityType : EntityType.values()) {
                    String string2 = entityType.name();
                    if (!string2.startsWith(string.toUpperCase(Locale.ENGLISH))) continue;
                    arrayList.add(string2);
                }
                break;
            }
        }
        return arrayList;
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.summon";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "summon";
    }
}

