/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.command.MECommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UndisguiseCommand
extends AbstractCommand {
    public UndisguiseCommand(AbstractCommand abstractCommand) {
        super(abstractCommand);
    }

    @Override
    public boolean onCommand(CommandSender commandSender, String[] stringArray) {
        Player player = (Player)commandSender;
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(player.getUniqueId());
        if (modeledEntity == null) {
            return true;
        }
        if (stringArray.length == 0) {
            modeledEntity.setBaseEntityVisible(true);
            ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(player, false);
            ModelEngineAPI.removeModeledEntity(player.getUniqueId());
        } else {
            for (String string : stringArray) {
                ActiveModel activeModel = modeledEntity.removeModel(string);
                if (activeModel == null) continue;
                activeModel.destroy();
            }
            if (modeledEntity.getModels().isEmpty()) {
                modeledEntity.setBaseEntityVisible(true);
                ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(player, false);
                ModelEngineAPI.removeModeledEntity(player.getUniqueId());
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Player player = (Player)commandSender;
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(player.getUniqueId());
        if (modeledEntity == null) {
            return arrayList;
        }
        if (stringArray.length > 0) {
            String string = stringArray[stringArray.length - 1];
            MECommand.getModelIdTabComplete(arrayList, string, modeledEntity);
        }
        return arrayList;
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.undisguise";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "undisguise";
    }
}

