/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator.atlas;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.utils.TFile;
import com.ticxo.modelengine.generator.atlas.Atlas;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class AtlasManager {
    private final ModelGenerator generator;
    private final File atlases;
    private final Set<String> registeredPaths = new HashSet<String>();
    private final Atlas atlas;

    public AtlasManager(ModelGenerator modelGenerator) {
        this.generator = modelGenerator;
        this.atlases = TFile.createDirectory(modelGenerator.getPackFolder(), "assets", "minecraft", "atlases");
        this.atlas = new Atlas();
        this.atlas.getSources().add(new Atlas.Directory("entity"));
    }

    public void addSingle(String string, String string2) {
        if (string.equals(this.generator.getNamespace()) && string2.startsWith("entity")) {
            return;
        }
        String string3 = string + ":" + string2;
        if (!this.registeredPaths.add(string3)) {
            return;
        }
        this.atlas.getSources().add(new Atlas.Single(string3));
    }

    public void generateFile() {
        try {
            File file = TFile.createFile(this.atlases, "blocks.json");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(ModelEngineAPI.gson.toJson((Object)this.atlas));
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Atlas getAtlas() {
        return this.atlas;
    }
}

